package com.ekingwin.bas.cloud.purchase.service.impl;

import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.purchase.dto.*;
import com.ekingwin.bas.cloud.purchase.util.ReadFileUtil;
import com.ekingwin.bas.cloud.purchase.dao.RequirementDao;
import com.ekingwin.bas.cloud.purchase.service.RequirementService;
import com.ekingwin.bas.cloud.purchase.vo.RequirementVo;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName RequirementServiceImpl.java
 * @Description TODO
 * @createTime 2020/3/16 10:30
 */
@Service
@Primary
public class RequirementServiceImpl implements RequirementService {

    @Autowired
    private RequirementDao requirementDao;
    @Value("${txt.url}")
    private String txtUrl;
    @Override
    public PageInfo queryAllDrafts(RequirementVo requirementVo) {
        PageHelper.startPage(requirementVo.getPageNum(), requirementVo.getPageSize());
        List<DraftsDto> draftsList = requirementDao.queryAllDrafts(requirementVo);
        PageInfo pageInfo = new PageInfo<>(draftsList);
        return pageInfo;
    }

    @Override
    public Boolean deletedrafts(RequirementVo requirementVo) {
        Boolean result = requirementDao.deletedrafts(requirementVo);
        return result;
    }

    @Override
    public PageInfo orderFailList(RequirementVo requirementVo) {
        PageHelper.startPage(requirementVo.getPageNum(), requirementVo.getPageSize());
        String userid = requirementVo.getUserid();
        List<AuthorityRoleDto> authorityRoleList = requirementDao.getanthorityRole(userid);
        List<OrderFailDto> orderFailList = new ArrayList<OrderFailDto>();
        if (authorityRoleList != null && !authorityRoleList.isEmpty()) {
            orderFailList = requirementDao.getorderFailList(requirementVo);
        } else {
            orderFailList = requirementDao.getorderFailList2(requirementVo);
        }
        PageInfo pageInfo = new PageInfo<>(orderFailList);
        return pageInfo;
    }

    @Override
    public Boolean orderFaildelete(String id) throws BasException {
        try {
            if (null != id) {
                String[] ids = id.split(",");
                for (String str : ids) {
                    requirementDao.orderFaildelete(str);
                }
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public PageInfo queryOrderList(RequirementVo requirementVo) {
        PageHelper.startPage(requirementVo.getPageNum(), requirementVo.getPageSize());
        String username=requirementVo.getUsername();
        String userid =username.substring(username.indexOf('(')+1,username.indexOf(')'));
        requirementVo.setIsadmin("N");
        List<AuthorityRoleDto> authorityRoleList = requirementDao.getanthorityRole(userid);
        List<OrderRecordDto> OrderRecordList=new ArrayList<OrderRecordDto>();
        if (authorityRoleList != null && !authorityRoleList.isEmpty()) {
            requirementVo.setIsadmin("Y");
             OrderRecordList= requirementDao.queryOrderList(requirementVo);
        }else{
             OrderRecordList= requirementDao.queryOrderList(requirementVo);
        }
        PageInfo pageInfo = new PageInfo<>(OrderRecordList);
        return pageInfo;
    }

    @Override
    public Map<String, Object> orderMessageDetails(String id) {
        Map<String, Object> map=new HashMap<>();
        String requestdetails= requirementDao.orderMessageDetails(id);
        if(StringUtils.isNotEmpty(requestdetails)){
//            String txturl=txtUrl+requestdetails;
          String txturl="C:\\Users\\kan\\Desktop\\0461c2d0-8e25-11e8-9ed3-3b15f023a974.txt";
            String data=ReadFileUtil.ReadTxtFile(txturl);
            map.put("requestdetails",data);
        }
        return map;
    }

    @Override
    public Map<String ,Object> orderRetransmission(String id, String username) {
        Map<String, Object> map=new HashMap<>();
        List<OrderRecordDto> orderRecordList=requirementDao.getInterfaceRecord(id);
        String flag="";
        String filename="";
        String returnmsg="";
        String requestdetails="";
        String orderid="";
        String applicant="";
        String ordernum="";
        String createdate="";
        String ordertype="";
        if(orderRecordList!=null && !orderRecordList.isEmpty()){
            for(int i=0;i<orderRecordList.size();i++){
                ordertype=orderRecordList.get(i).getOrdertype();
                orderid=orderRecordList.get(i).getOrderid().toString();
                ordernum=orderRecordList.get(i).getOrdernum();
                applicant=orderRecordList.get(i).getApplicant();
                createdate=orderRecordList.get(i).getCreatedate();
                requestdetails=orderRecordList.get(i).getRequestdetails();
            }
        }
        if(StringUtils.isNotEmpty(ordernum)){
            List<OrderGoodsDto> OrderList=requirementDao.getOrderWithOrdernum(ordernum);
            if(OrderList==null && OrderList.isEmpty()){
                map.put("message","该订单在通威商城中不存在，不能重发SRM！");
                return map;
            }
        }
        requirementDao.updateRetransmission(id);
        if(StringUtils.isNotEmpty(requestdetails)){
            //txt文件所在服务器路径
            String txturl=txtUrl+requestdetails;
            //读取文件内容
            String data=ReadFileUtil.ReadTxtFile(txturl);
            //转json格式
            JSONObject jsonStr = JSONObject.fromObject(data);
            if(StringUtils.isNotEmpty(jsonStr)) {
                map.put("orderid", jsonStr.get("orderid"));
                map.put("ordernum", jsonStr.get("ordernum"));
                map.put("ordertype", jsonStr.get("ordertype"));
                map.put("applicant", jsonStr.get("applicant"));
                map.put("createdate", jsonStr.get("createdate"));
            }
        }

        return map;
    }
}
