package com.ekingwin.bas.cloud.purchase.service.impl;

import com.ekingwin.bas.cloud.cart.service.IpCartService;
import com.ekingwin.bas.cloud.portal.dao.IPurchasingPlatformDao;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformAddVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformOrderAddVo;
import com.ekingwin.bas.cloud.purchase.dao.SpecicalPurchaseDao;
import com.ekingwin.bas.cloud.purchase.dto.*;

import com.ekingwin.bas.cloud.purchase.service.SpecicalPurchaseService;
import com.ekingwin.bas.cloud.purchase.vo.GetOrderVo;
import com.ekingwin.bas.cloud.purchase.vo.ReplyGetOrderVo;
import com.ekingwin.bas.cloud.purchase.vo.ReplyOrderVo;
import com.ekingwin.bas.cloud.purchase.vo.SpecicalPurchaseVo;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.util.StringUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

import static java.lang.Float.parseFloat;
import static java.lang.Integer.parseInt;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName SpecicalPurchaseServiceImpl.java
 * @Description TODO
 * @createTime 2020/4/7 11:09
 */
@Service
@Primary
public class SpecicalPurchaseServiceImpl implements SpecicalPurchaseService {
    @Autowired
    private SpecicalPurchaseDao specicalPurchaseDao;
    @Autowired
    private IPurchasingPlatformDao purchasingPlatformDao;
    @Autowired
    private IpCartService ipCartService;
    @Value("${dataSourceName3}")
    private String jcybasUrl;
    @Value("${dataSourceName}")
    private String twbusUrl;
    @Value("${order.approve}")
    private String orderapprove;

    @Override
    public SpecicalPurchaseDto getGoods(SpecicalPurchaseVo specicalPurchaseVo) {
        SpecicalPurchaseDto specicalPurchaseDto = new SpecicalPurchaseDto();
        if (specicalPurchaseVo.getDeptname() == null) {
            specicalPurchaseVo.setOrdertype("");
        }
        if (specicalPurchaseVo.getOrdertype() == null) {
            specicalPurchaseVo.setOrdertype("标准采购");
        }
        if ("服务类采购".equals(specicalPurchaseVo.getOrdertype())) {
            specicalPurchaseVo.setOrdertype("专项采购");
        }
        if ("工程/项目/服务类采购".equals(specicalPurchaseVo.getOrdertype())) {
            specicalPurchaseVo.setOrdertype("费用化采购采购");
        }
        String empuid = specicalPurchaseVo.getUserid();
        List<Map<String, String>> employeeList = specicalPurchaseDao.getGoods1(empuid);
        List<Map<String, String>> invoiceList = new ArrayList<>();
        if (StringUtils.isNotEmpty(specicalPurchaseVo.getCompanyid())) {
            invoiceList = specicalPurchaseDao.getGoods2(specicalPurchaseVo.getCompanyid());
        }
        if ("()".equals(specicalPurchaseVo.getIds())) {
            specicalPurchaseDto.setCurrency("CNY");
            StringBuffer Str = new StringBuffer();
            Str.append(specicalPurchaseVo.getDeptname());
            Str.append(specicalPurchaseVo.getOrdertype());
            if (StringUtils.isEmpty(specicalPurchaseDto.getSupplier())) {
                specicalPurchaseDto.setSupplier("");
            }
            Str.append("(" + specicalPurchaseDto.getSupplier() + ")");
            //自动生成：采购部门+采购单类型
            specicalPurchaseDto.setOrdername(Str.toString());
            //默认标准采购
            specicalPurchaseDto.setOrdertype(specicalPurchaseVo.getOrdertype());
            specicalPurchaseDto.setOrdernum("");
            specicalPurchaseDto.setBuyer(employeeList.get(0).get("cnname"));
            specicalPurchaseDto.setUserid(specicalPurchaseVo.getUserid());
            //当前登录人所属部门
            specicalPurchaseDto.setDeptid(specicalPurchaseVo.getDeptid());
            //当前登录人所属公司
            specicalPurchaseDto.setCompanyid(specicalPurchaseVo.getCompanyid());
            //当前登录人所属部门
            specicalPurchaseDto.setDeptname(specicalPurchaseVo.getDeptname());
            //当前登录人所属公司
            specicalPurchaseDto.setCompanyname(specicalPurchaseVo.getCompanyname());
            specicalPurchaseDto.setSmallamount("0.00");
            //根据当前登录人所属公司开票信息带出
            specicalPurchaseDto.setInvoicetitle(invoiceList.get(0).get("invoicetitle"));
            specicalPurchaseDto.setTaxnumber(invoiceList.get(0).get("taxnum"));
            specicalPurchaseDto.setUnitaddress(invoiceList.get(0).get("unitaddress"));
            specicalPurchaseDto.setSphone(invoiceList.get(0).get("telephone"));
            specicalPurchaseDto.setDepositbank(invoiceList.get(0).get("openbank"));
            specicalPurchaseDto.setAccount(invoiceList.get(0).get("openbankaccount"));
            specicalPurchaseDto.setReceiver(employeeList.get(0).get("cnname"));
            specicalPurchaseDto.setDeliverycompanyname(specicalPurchaseVo.getCompanyname());
            specicalPurchaseDto.setReceivedept(specicalPurchaseVo.getDeptname());
            specicalPurchaseDto.setPhone(employeeList.get(0).get("phone"));
            specicalPurchaseDto.setEmail(employeeList.get(0).get("email"));
            specicalPurchaseDto.setTotalhsprice("0.00");
            specicalPurchaseDto.setTotalprice("0.00");
            specicalPurchaseDto.setTotalbhsprice("0.00");
            Map buyType = new HashMap();
            buyType.put("采购类型1", "专项采购");
            buyType.put("采购类型2", "费用化采购");
            specicalPurchaseDto.setBuyType(buyType);
        } else {
            String ids = specicalPurchaseVo.getIds();
            List<IpcCart2Dto> IpcCartList = specicalPurchaseDao.getGoods3(ids);
            String totalhsprice = "0.00";
            SprcicalGoodsDto SprcicalGoodsDto = new SprcicalGoodsDto();
            if (IpcCartList != null && !IpcCartList.isEmpty()) {
                for (int i = 0; i < IpcCartList.size(); i++) {
                    //字符串格式化保留两位小数
                    totalhsprice = String.format("%.2f", (parseFloat(totalhsprice) + (parseFloat(IpcCartList.get(i).getPrice()) * parseFloat(IpcCartList.get(i).getCount()))));
                    SprcicalGoodsDto.setGoodsid(IpcCartList.get(i).getGoodsid());
                    SprcicalGoodsDto.setHsprice(String.format("%.2f", parseFloat(IpcCartList.get(i).getPrice())));
                    SprcicalGoodsDto.setPrice(String.format("%.2f", parseFloat(IpcCartList.get(i).getPrice())));
                    SprcicalGoodsDto.setCount(IpcCartList.get(i).getCount());
                    List<Map<String, String>> goodList = specicalPurchaseDao.getGoods4(ids, IpcCartList.get(i).getGoodsid(), specicalPurchaseVo.getUserid(), jcybasUrl, twbusUrl);
                    if (goodList != null && !goodList.isEmpty()) {
                        if (StringUtils.isNotEmpty(goodList.get(0).get("taxrate"))) {
                            goodList.get(0).put("taxrate", "0");
                        }
                        if (StringUtils.isNotEmpty(goodList.get(0).get("currency"))) {
                            goodList.get(0).put("currency", "CNY");
                        }
                        SprcicalGoodsDto.setPricetype(goodList.get(0).get("pricetype"));
                        SprcicalGoodsDto.setMinimumquantity(goodList.get(0).get("minimumquantity"));
                        SprcicalGoodsDto.setDeliveryaddress(goodList.get(0).get("returnAddress"));
                        specicalPurchaseDto.setMaterialclassify(goodList.get(0).get("materialclassify"));
                        specicalPurchaseDto.setCurrency(goodList.get(0).get("currency"));
                        SprcicalGoodsDto.setTotalhsprice(String.format("%.2f", parseFloat(IpcCartList.get(i).getPrice()) * parseFloat(IpcCartList.get(i).getCount())));
                        SprcicalGoodsDto.setTotalprice(String.format("%.2f", parseFloat(IpcCartList.get(i).getPrice()) * parseFloat(IpcCartList.get(i).getCount())));
                        SprcicalGoodsDto.setTotalbhsprice(String.format("%.2f", parseFloat(IpcCartList.get(i).getPrice()) * parseFloat(IpcCartList.get(i).getCount()) * (1 - parseFloat(goodList.get(0).get("taxrate")) / 100)));
                        SprcicalGoodsDto.setHsprice(IpcCartList.get(i).getPrice());
                        SprcicalGoodsDto.setBhsprice(String.format("%.2f", parseFloat(IpcCartList.get(i).getPrice()) / (1 + parseFloat(goodList.get(0).get("taxrate")) / 100)));
                        SprcicalGoodsDto.setTaxrate(goodList.get(0).get("taxrate"));
                        SprcicalGoodsDto.setMaterialclassify(goodList.get(0).get("materialclassify"));
                        SprcicalGoodsDto.setCurrency(goodList.get(0).get("currency"));
                        SprcicalGoodsDto.setCandate(goodList.get(0).get("candate"));
                        SprcicalGoodsDto.setFTNPSpecificationsModel(goodList.get(0).get("FTNPSpecificationsModel"));
                        SprcicalGoodsDto.setBrand(goodList.get(0).get("brand"));
                        SprcicalGoodsDto.setBrandname(goodList.get(0).get("brandname"));
                        SprcicalGoodsDto.setMdmcode(goodList.get(0).get("mdmcode"));
                        SprcicalGoodsDto.setWareid(goodList.get(0).get("wareid"));
                        SprcicalGoodsDto.setGoodsname(goodList.get(0).get("name"));
                        SprcicalGoodsDto.setGoodsnum(goodList.get(0).get("goodsnum"));
                        SprcicalGoodsDto.setScription(goodList.get(0).get("scription"));
                        SprcicalGoodsDto.setSupplier(goodList.get(0).get("suppliername"));
                        SprcicalGoodsDto.setSupplierid(goodList.get(0).get("supplierid"));
                        SprcicalGoodsDto.setSuppliernum(goodList.get(0).get("suppliernum"));
                        specicalPurchaseDto.setSupplier(goodList.get(0).get("suppliername"));
                        StringBuffer Str = new StringBuffer();
                        Str.append(specicalPurchaseVo.getDeptname());
                        Str.append(specicalPurchaseVo.getOrdertype());
                        Str.append("(" + specicalPurchaseDto.getSupplier() + ")");
                        specicalPurchaseDto.setOrdername(Str.toString());
                        specicalPurchaseDto.setSuppliernum(goodList.get(0).get("suppliernum"));
                        specicalPurchaseDto.setSupplierid(goodList.get(0).get("supplierid"));
                        SprcicalGoodsDto.setUnit(goodList.get(0).get("unit"));
                        SprcicalGoodsDto.setUnitname(goodList.get(0).get("unitname"));
                        SprcicalGoodsDto.setStock(goodList.get(0).get("stock"));
                        SprcicalGoodsDto.setFTNPFirstCategoryCode(goodList.get(0).get("FTNPFirstCategoryCode"));
                        SprcicalGoodsDto.setFTNPFirstCategoryName(goodList.get(0).get("FTNPFirstCategoryName"));
                        SprcicalGoodsDto.setFTNPSecondCategoryCode(goodList.get(0).get("FTNPSecondCategoryCode"));
                        SprcicalGoodsDto.setFTNPSecondCategoryName(goodList.get(0).get("FTNPSecondCategoryName"));
                        SprcicalGoodsDto.setFTNPThreeCategoryCode(goodList.get(0).get("FTNPThreeCategoryCode"));
                        SprcicalGoodsDto.setFTNPThreeCategoryName(goodList.get(0).get("FTNPThreeCategoryName"));
                        SprcicalGoodsDto.setFTNPMaterialConsdescription(goodList.get(0).get("FTNPMaterialConsdescription"));
                        SprcicalGoodsDto.setFreightcharges(goodList.get(0).get("freightcharges"));
                        SprcicalGoodsDto.setFreight(goodList.get(0).get("freight"));
                        SprcicalGoodsDto.setIsinquiry(goodList.get(0).get("isinquiry"));
                        SprcicalGoodsDto.setFreightprice(goodList.get(0).get("price"));
                        SprcicalGoodsDto.setConfirmprice(goodList.get(0).get("price"));
                        SprcicalGoodsDto.setTaxunitprice(SprcicalGoodsDto.getConfirmprice());
                        if (StringUtils.isNotEmpty(goodList.get(0).get("candate"))) {
                            goodList.get(0).put("candate", "0");
                        }
                        SprcicalGoodsDto.setDeliverydate(String.valueOf(parseInt(goodList.get(0).get("candate")) + 3));
                        SprcicalGoodsDto.setTotalamount(String.format("%.2f", (parseFloat(IpcCartList.get(i).getPrice()) * parseFloat(IpcCartList.get(i).getCount()))));
                    }
                    if (StringUtils.isNotEmpty(SprcicalGoodsDto.getWareid())) {
                        SprcicalGoodsDto.setPricetype("京东");
                        specicalPurchaseDto.setPurchasetype("京东");
                    } else {
                        SprcicalGoodsDto.setPricetype("京东");
                        specicalPurchaseDto.setPurchasetype("非京东");
                    }
                    List<SprcicalGoodsDto> list = new ArrayList<>();
                    list.add(SprcicalGoodsDto);
                    specicalPurchaseDto.setGoods(list);
                }
            } else {
                specicalPurchaseDto.setCurrency("CNY");
                StringBuffer Str = new StringBuffer();
                Str.append(specicalPurchaseVo.getDeptname());
                Str.append(specicalPurchaseVo.getOrdertype());
                Str.append("(" + specicalPurchaseDto.getSupplier() + ")");
                //自动生成：采购部门+采购单类型
                specicalPurchaseDto.setOrdername(Str.toString());
                //默认标准采购
                specicalPurchaseDto.setOrdertype(specicalPurchaseVo.getOrdertype());
                specicalPurchaseDto.setOrdernum("");
                specicalPurchaseDto.setBuyer(employeeList.get(0).get("cnname"));
                //当前登录人所属部门
                specicalPurchaseDto.setDeptid(specicalPurchaseVo.getDeptid());
                //当前登录人所属公司
                specicalPurchaseDto.setCompanyid(specicalPurchaseVo.getCompanyid());
                //当前登录人所属部门
                specicalPurchaseDto.setDeptname(specicalPurchaseVo.getDeptname());
                //当前登录人所属公司
                specicalPurchaseDto.setCompanyname(specicalPurchaseVo.getCompanyname());
                specicalPurchaseDto.setSmallamount("0.00");
                //根据当前登录人所属公司开票信息带出
                specicalPurchaseDto.setInvoicetitle(invoiceList.get(0).get("invoicetitle"));
                specicalPurchaseDto.setTaxnumber(invoiceList.get(0).get("taxnum"));
                specicalPurchaseDto.setUnitaddress(invoiceList.get(0).get("unitaddress"));
                specicalPurchaseDto.setSphone(invoiceList.get(0).get("telephone"));
                specicalPurchaseDto.setDepositbank(invoiceList.get(0).get("openbank"));
                specicalPurchaseDto.setAccount(invoiceList.get(0).get("openbankaccount"));
                specicalPurchaseDto.setReceiver(employeeList.get(0).get("cnname"));
                specicalPurchaseDto.setDeliverycompanyname(specicalPurchaseVo.getCompanyname());
                specicalPurchaseDto.setReceivedept(specicalPurchaseVo.getDeptname());
                specicalPurchaseDto.setPhone(employeeList.get(0).get("phone"));
                specicalPurchaseDto.setEmail(employeeList.get(0).get("email"));
                specicalPurchaseDto.setTotalhsprice("0.00");
                specicalPurchaseDto.setTotalprice("0.00");
                specicalPurchaseDto.setTotalbhsprice("0.00");
                specicalPurchaseDto.setSmallamount(specicalPurchaseDto.getTotalhsprice());
            }
        }
        if (StringUtils.isNotEmpty(specicalPurchaseDto.getSupplierid())) {
            List<Map<String, String>> map = specicalPurchaseDao.getGoods5(specicalPurchaseDto.getSupplierid(), twbusUrl);
            if (map != null && !map.isEmpty()) {
                specicalPurchaseDto.setReceivablesaccount(map.get(0).get("account"));
            }
        }
        return specicalPurchaseDto;
    }

    /**
     * 获取最新的订单编码
     * @return
     */
    @Override
    public String getOrdernum() {
        String ponum="";
        StringBuffer POnum = new StringBuffer();
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateNowStr = sdf.format(d);
        POnum.append("TWSC");
        POnum.append(dateNowStr);
        String ordernum = specicalPurchaseDao.getPonum(POnum.toString());
        if (StringUtils.isEmpty(ordernum)) {
            POnum.append("0001");
            ponum=POnum.toString();
        } else {
            String num = "TWSC";
            String a = ordernum.substring(4, 16);
            BigInteger b = new BigInteger(a);
            BigInteger c = new BigInteger("1");
            //BigInteger的加法运算
            String upnum = b.add(c) + "";
            ponum=num + upnum;
        }
        return ponum;
    }
    /**
     * 采购订单信息推送SRM
     *
     * @param purchasingPlatformAddVo
     * @return
     */
    @Override
    public Result submit(PurchasingPlatformAddVo purchasingPlatformAddVo) {
        //获取最新的订单编号
        String ordernum=this.getOrdernum();
        purchasingPlatformAddVo.setPonum(ordernum);
        //默认订单状态—审批中
        purchasingPlatformAddVo.setState("审批中");
        //创建时间
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String inputdate = df.format(date);
        purchasingPlatformAddVo.setInputdate(inputdate);
        purchasingPlatformAddVo.setOrdertype(purchasingPlatformAddVo.getType());
        purchasingPlatformAddVo.setBuyer(purchasingPlatformAddVo.getUserid());
        purchasingPlatformAddVo.setInputperson(purchasingPlatformAddVo.getUserid());
        try {
            //添加到ip_c_order表
            specicalPurchaseDao.addorder(purchasingPlatformAddVo);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("添加到ip_c_order表失败");
        }
        //查询ip_c_order的id以及状态
        OrderIdAndStateDto IdstateDto = specicalPurchaseDao.queryorderidandstate(purchasingPlatformAddVo);
        //查询seq当前值
        Integer seqq = purchasingPlatformDao.queryipCOrderAllgoodsDrafts();
        int seq = seqq + 1;
        for (int i = 0; i < purchasingPlatformAddVo.getPlatformOrderAddVos().size(); i++) {
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setSupplier(purchasingPlatformAddVo.getSupplier());
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setPonum(purchasingPlatformAddVo.getPonum());
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setState(IdstateDto.getState());
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setOrderid(IdstateDto.getId());
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setMaterialclassify(purchasingPlatformAddVo.getMaterialclassify());
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setCurrency(purchasingPlatformAddVo.getCurrency());
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setSeq(seq);
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setTotalbhsprice(purchasingPlatformAddVo.getTotalbhsprice());
            purchasingPlatformAddVo.getPlatformOrderAddVos().get(i).setReceipttime(inputdate);
            try {
                //添加到ip_c_order_allgoods表
                specicalPurchaseDao.addOrderAllGoods(purchasingPlatformAddVo.getPlatformOrderAddVos().get(i));
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("添加到ip_s_order_allgoods表失败");
            }
        }
        purchasingPlatformAddVo.setDocsystem("SYC");
        purchasingPlatformAddVo.setDocoldid(purchasingPlatformAddVo.getDocid());
        purchasingPlatformAddVo.setDocfilename(purchasingPlatformAddVo.getDocname());

        try {
            //添加到ip_c_order_attachment
            specicalPurchaseDao.addOrderAttachment(purchasingPlatformAddVo);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("添加到ip_c_order_attachment表失败");
        }

        //如果是草稿箱中的订单，清理该记录
        if ("Y".equals(purchasingPlatformAddVo.getIsdrafts())) {
            if (StringUtils.isNotEmpty(purchasingPlatformAddVo.getDraftsid())) {
                specicalPurchaseDao.deletedraftsid(purchasingPlatformAddVo.getDraftsid());
            }
        }
        //发起审批
        Map<String, Object> map = this.orderapprovetoesb(purchasingPlatformAddVo);
        if (map.containsKey("code")) {
            //发起流程成功，删除购物车中该订单，并释放库存
            if ("Y".equals(map.get("code"))) {
                if ("标准采购".equals(purchasingPlatformAddVo.getOrdertype())) {
                    ipCartService.deletecart(purchasingPlatformAddVo.getIds());
                }
            }
            return Result.ok(map);
        } else {
            return Result.error(map.get("errorCode").toString());
        }
    }

    /**
     * 采购订单审批接口
     *
     * @param purchasingPlatformAddVo
     * @return
     */
    @Override
    public Map<String, Object> orderapprovetoesb(PurchasingPlatformAddVo purchasingPlatformAddVo) {
        Map<String, Object> result = new HashMap<String, Object>();
        JSONObject json = new JSONObject();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        String newdate = df.format(new Date());
        String newdate2 = df2.format(new Date());
        //获取采购商品详情
        List<PurchasingPlatformOrderAddVo> platformOrderAddVos = purchasingPlatformAddVo.getPlatformOrderAddVos();
        List<GoodsToSrmDto> oodsToSrmList = new ArrayList<>();
        GoodsToSrmDto goodsToSrmDto = new GoodsToSrmDto();
        for (int i = 0; i < platformOrderAddVos.size(); i++) {
            goodsToSrmDto.setCategorycode(platformOrderAddVos.get(i).getFTNPFirstCategoryCode());//一级分类编码
            goodsToSrmDto.setCategorydesc(platformOrderAddVos.get(i).getFTNPFirstCategoryName());//一级分类名称
            goodsToSrmDto.setConfirmPrice(platformOrderAddVos.get(i).getTaxunitprice());//确认单价
            goodsToSrmDto.setDeliveryDetailedAddr(purchasingPlatformAddVo.getDeliveryaddress());//交货地址
            goodsToSrmDto.setDeliveryWay(purchasingPlatformAddVo.getPricetype());//价格类型，PRICE-到厂价，SELFPRICE-自提价，ARRIVALPRICE-到站价，PORRPRICE-到港价
            goodsToSrmDto.setFchargesPrice(platformOrderAddVos.get(i).getFreight());//运费单价（元）
            goodsToSrmDto.setFreightCharges(platformOrderAddVos.get(i).getFreightcharges());//含运费
            goodsToSrmDto.setFreightPrice(platformOrderAddVos.get(i).getFreightprice());//出厂单价（元）
            goodsToSrmDto.setGoodBrandAddr(platformOrderAddVos.get(i).getBrand());//品牌
            goodsToSrmDto.setIsInquiry(purchasingPlatformAddVo.getIsinquiry());//是否询价
            goodsToSrmDto.setItemCode(platformOrderAddVos.get(i).getMdmcode());//物料编码
            goodsToSrmDto.setItemName(platformOrderAddVos.get(i).getGoodsname());//商品名称（EBS物料名称）
            goodsToSrmDto.setItemNum(platformOrderAddVos.get(i).getGoodsid().toString());//商品编码
            goodsToSrmDto.setMultRate("0");//多税率
            goodsToSrmDto.setProductName(platformOrderAddVos.get(i).getGoodsname());//品名
            goodsToSrmDto.setProductType(platformOrderAddVos.get(i).getMaterialclassify());//商品类型
            goodsToSrmDto.setPromisedDate(platformOrderAddVos.get(i).getDeliverydate());//交货完成日期
            goodsToSrmDto.setQty(platformOrderAddVos.get(i).getCount());//数量
            goodsToSrmDto.setTaxRate(platformOrderAddVos.get(i).getTaxrate());//税率（%）
            goodsToSrmDto.setTaxUnitPrice(platformOrderAddVos.get(i).getTaxunitprice());//到厂单价
            goodsToSrmDto.setTotalAmount(platformOrderAddVos.get(i).getTotalamount());//全额（不含税合计/含税合计）
            goodsToSrmDto.setTreelevelcode(platformOrderAddVos.get(i).getFTNPThreeCategoryCode());//三级分类编码
            goodsToSrmDto.setTwolevelcode(platformOrderAddVos.get(i).getFTNPSecondCategoryCode());//二级分类编码
            goodsToSrmDto.setTwoleveldesc(platformOrderAddVos.get(i).getFTNPFirstCategoryName());//二级分类名称
            goodsToSrmDto.setTypecode(platformOrderAddVos.get(i).getFTNPThreeCategoryName());//三级分类名称
            goodsToSrmDto.setUnitMeasLookupCode(platformOrderAddVos.get(i).getUnit());//计量单位
            oodsToSrmList.add(goodsToSrmDto);
        }
        //商品清单转json
        JSONArray srmPonMallLinesVOList = JSONArray.fromObject(oodsToSrmList);
        /**
         * 报文没拼接好，待客户确认
         */
        json.element("accountName", purchasingPlatformAddVo.getSupplier());
        json.element("accountNum", purchasingPlatformAddVo.getShroffaccount());
        json.element("arrivalAddress", purchasingPlatformAddVo.getDeliverycompanyname());
        json.element("bankName", purchasingPlatformAddVo.getReceivablesname());
        json.element("branchName", purchasingPlatformAddVo.getReceivablesaccount());
        json.element("buyer", purchasingPlatformAddVo.getUserid());
        json.element("comCode", "10000001");
        json.element("comName", purchasingPlatformAddVo.getCompanyname());
        json.element("contactsAddress", purchasingPlatformAddVo.getDeliveryaddress());
        json.element("contactsCom", purchasingPlatformAddVo.getDeliverycompanyname());
        json.element("contactsDept", purchasingPlatformAddVo.getReceivedept());
        json.element("contactsId", purchasingPlatformAddVo.getUserid());
        json.element("contractMoney", purchasingPlatformAddVo.getTotalhsprice());
        json.element("contractName", purchasingPlatformAddVo.getTitle());
        json.element("contractStatus", purchasingPlatformAddVo.getUserid());
        json.element("contractType", "采购类合同");
        json.element("contracttemplete", "非原料物资购销合同");
        json.element("creationDate", newdate2);
        json.element("currency", platformOrderAddVos.get(0).getCurrency());
        json.element("deptCode", "10000014");
        json.element("deptName", "信息部");
        json.element("directBuyCause", purchasingPlatformAddVo.getPurchasereason());
        json.element("email", purchasingPlatformAddVo.getEmail());
        json.element("invoiceAddress", purchasingPlatformAddVo.getDeliveryaddress());
        json.element("invoiceTitle", purchasingPlatformAddVo.getCompanyname());
        json.element("jobCode", "10000113");
        json.element("jobName", "总部信息部软件开发工程师");
        json.element("operator", purchasingPlatformAddVo.getUserid());
        json.element("orderCurrency", platformOrderAddVos.get(0).getCurrency());
        json.element("orderType", purchasingPlatformAddVo.getType());
        json.element("orgId", "10000001");
        json.element("receiveAccount", purchasingPlatformAddVo.getReceivablesaccount());
        json.element("poOtherRequire", purchasingPlatformAddVo.getGoodsotherrequire());
        json.element("rmbAllAmount", purchasingPlatformAddVo.getTotalhsprice());
        json.element("rmbAllAmountTax", purchasingPlatformAddVo.getTotalhsprice());
        json.element("sbank", purchasingPlatformAddVo.getReceivablesname());
        json.element("sbankAccount", purchasingPlatformAddVo.getReceivablesaccount());
        json.element("siteInfo", purchasingPlatformAddVo.getUnitaddress());
        json.element("sourceName", purchasingPlatformAddVo.getTitle());
        json.element("sourceNum", purchasingPlatformAddVo.getPonum());
        json.element("sourceOrder", purchasingPlatformAddVo.getPonum());
        json.element("sourceType", purchasingPlatformAddVo.getType());
        json.element("sphone", purchasingPlatformAddVo.getPhone());
        json.element("srmPonFileVOList", "[]");
        json.element("srmPonMallLinesVOList", srmPonMallLinesVOList);
//        json.element("srmPonMallLinesVOList", "[{\n" +
//                "\t\t\"categorycode\": \"71\",\n" +
//                "\t\t\"categorydesc\": \"饲料生产设备\",\n" +
//                "\t\t\"confirmPrice\": \"43\",\n" +
//                "\t\t\"deliveryDetailedAddr\": \""+purchasingPlatformAddVo.getDeliveryaddress()+"\",\n" +
//                "\t\t\"deliveryWay\": \"PRICE\",\n" +
//                "\t\t\"fchargesPrice\": \"0\",\n" +
//                "\t\t\"freightCharges\": \"是\",\n" +
//                "\t\t\"freightPrice\": \""+platformOrderAddVos.get(0).getFreightprice()+"\",\n" +
//                "\t\t\"goodBrandAddr\": \"镇江三维\",\n" +
//                "\t\t\"isInquiry\": \"是\",\n" +
//                "\t\t\"itemCode\": \"710000804\",\n" +
//                "\t\t\"itemName\": \"镇江三维输送机Băng tải +TGSS32+埋刮板\",\n" +
//                "\t\t\"itemNum\": \"710000804S2017040277\",\n" +
//                "\t\t\"multRate\": \"0\",\n" +
//                "\t\t\"productName\": \""+platformOrderAddVos.get(0).getGoodsname()+"\",\n" +
//                "\t\t\"productType\": \"C\",\n" +
//                "\t\t\"promisedDate\": \""+newdate2+"\",\n" +
//                "\t\t\"qty\": \""+platformOrderAddVos.get(0).getCount()+"\",\n" +
//                "\t\t\"taxRate\": \"0\",\n" +
//                "\t\t\"taxUnitPrice\": \"43\",\n" +
//                "\t\t\"totalAmount\": \"129.00\",\n" +
//                "\t\t\"treelevelcode\": \"710215\",\n" +
//                "\t\t\"twolevelcode\": \"7102\",\n" +
//                "\t\t\"twoleveldesc\": \"专用设备\",\n" +
//                "\t\t\"typecode\": \"输送设备\",\n" +
//                "\t\t\"unitMeasLookupCode\": \"台\"\n" +
//                "\t}]");
        json.element("startDate", newdate);
        json.element("strategy", "单一来源采购");
        json.element("taxRegistreNum", "zhangb");
        json.element("telNumber", "zhangb");
        json.element("vendorId", "S2017040277");
        try {
            System.out.println(json);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            //拼写接口报文
            RestTemplate restTemplate = new RestTemplate();
            //向接口传递数据
            //拼写好的报文提交
            HttpEntity<JSONObject> he = new HttpEntity<JSONObject>(json, headers);
            @SuppressWarnings("rawtypes")
            ResponseEntity<Map> resultjson = restTemplate.exchange(orderapprove, HttpMethod.POST, he, Map.class);
            Map<String, Object> restmap = resultjson.getBody();
            //打印返回信息
            System.out.println("=================================================");
            System.out.println("推送接口返回：" + restmap);
            String code = "code";
            if (restmap.containsKey(code)) {
                result.put("code", restmap.get("code").toString());
                result.put("message", restmap.get("message").toString());
            } else {
                result.put("errorCode", restmap.get("errorCode"));
            }
        } catch (Exception e) {
            System.out.println("请求报文：" + json);
            System.out.println("请求调用失败" + e);
        }
        return result;
    }

    /**
     * 采购审批回写审批意见(该接口作废)
     *
     * @param map
     * @return
     */
    @Override
    public Result replysubmit(Map<String, Object> map) {
        //审批状态 N：不同意 Y：同意 RO：退回发起人
        String state = map.get("state").toString();
        //
        String processnum = map.get("processnum").toString();
        String opinion = map.get("opinion").toString();
        //根据流程id写入审批状态
        try {
            Boolean f = specicalPurchaseDao.updatestate(state, processnum);
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("更新失败" + e.getMessage());
        }
        return Result.ok();
    }

    /**
     * 订单创建结果回传
     *
     * @param replyOrderVo
     * @return
     */
    @Override
    public Result replycreateorder(ReplyOrderVo replyOrderVo) {
        //是否有该订单
        String ordertype = specicalPurchaseDao.getordertype(replyOrderVo.getOrdernum());
        if (StringUtils.isNotEmpty(ordertype)) {
            if (StringUtils.isEmpty(replyOrderVo.getAttr1())) {
                if ("1".equals(replyOrderVo.getStatus())) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    replyOrderVo.setAppproedate(df.format(new Date()));
                    if ("1".equals(replyOrderVo.getProvstatus())) {
                        replyOrderVo.setProvstatus("审批中");
                    } else if ("2".equals(replyOrderVo.getProvstatus())) {
                        replyOrderVo.setProvstatus("待发货");
                    } else if ("3".equals(replyOrderVo.getProvstatus())) {
                        replyOrderVo.setProvstatus("已终止");
                    } else if ("4".equals(replyOrderVo.getProvstatus())) {
                        replyOrderVo.setProvstatus("退回");
                    }
                    specicalPurchaseDao.updatestate2(replyOrderVo);
                    specicalPurchaseDao.updateallgoods(replyOrderVo.getProvstatus(), replyOrderVo.getOrdernum());
                } else {
                    OrderDto orderDto = specicalPurchaseDao.getorder(replyOrderVo.getOrdernum());
                    orderDto.setStatusdesc(replyOrderVo.getStatusdesc());
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    orderDto.setNewdate(df.format(new Date()));
                    specicalPurchaseDao.addorderfaillogs(orderDto);
                    return Result.ok("采购订单回传接口，订单：" + replyOrderVo.getOrdernum() + "，状态更新失败，已移交订单失败记录表（ip_c_order_orderfail_logs）");
                }
            } else {
                //传值为Y时，只更新FBC详情链接
                if ("Y".equals(replyOrderVo.getAttr1())) {
                    specicalPurchaseDao.updateorderbpmurl(replyOrderVo.getDetaillink(), replyOrderVo.getOrdernum());
                    return Result.ok("采购订单回传接口，订单：" + replyOrderVo.getOrdernum() + "，异步更新订单流程链接成功！");
                }
            }
        } else {
            return Result.ok("没有该订单");
        }
        return Result.ok("采购订单回传接口，订单：" + replyOrderVo.getOrdernum() + "，状态更新成功");

    }

    @Override
    public Result replygetgoods(ReplyGetOrderVo replyGetOrderVo) {
        for(GetOrderVo orderVo:replyGetOrderVo.getReplyGetOrderList()){
            //验证ip_c_order_allgoods中是否是可收货状态
            Map<String,String> map=specicalPurchaseDao.verifyAllGoods(orderVo);
            String state=map.get("status");
            String goodsid=map.get("goodsid");
            if(map!=null && !map.isEmpty()){
                if("已收货".equals(state)){
                    specicalPurchaseDao.updateAllGoods(state,orderVo.getOrdernum(),orderVo.getMaterielsid());
                    specicalPurchaseDao.updateipsgoods(goodsid,orderVo.getReceiptcount(),twbusUrl);
                    Map<String,String> pricemap= specicalPurchaseDao.getprice(orderVo);
                    String receiptid=map.get("id");
                    if(map!=null && !map.isEmpty()){
                        String hsprice=map.get("hsprice");
                        String bhsprice=map.get("bhsprice");
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String newdate=df.format(new Date());
                        specicalPurchaseDao.updateipcreceipt(newdate,orderVo.getReceiptcount(),orderVo.getOrdernum(),hsprice,bhsprice);
                    }else{
                        specicalPurchaseDao.addipcreceipt(orderVo);
                    }
                    specicalPurchaseDao.addicpreceiptallgoods(receiptid,orderVo.getOrdernum(),orderVo.getMaterielsid(),orderVo.getReceiptcount());
                }
            }
        }
        return Result.ok("收货成功");
    }
}