package com.ekingwin.bas.cloud.purchase.web;

import com.ekingwin.bas.cloud.purchase.dto.IpPurchaseOrderDto;
import com.ekingwin.bas.cloud.purchase.dto.OrderGoodsDto;
import com.ekingwin.bas.cloud.purchase.service.IpPurchaseOrderService;
import com.ekingwin.bas.cloud.purchase.vo.InterfaceVo;
import com.ekingwin.bas.cloud.purchase.vo.IpPurchaseOrderVo;
import com.ekingwin.bas.cloud.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName PurchaseOrderController.java
 * @Description TODO
 * @createTime 2020/3/10 15:21
 */
@RestController
@RequestMapping(value = "/purchaseOrder/")
@Api(tags = "订单详情", description = "订单详情", value = "订单详情")
public class IpPurchaseOrderController {

    @Autowired
    private IpPurchaseOrderService ipPurchaseOrderService;
    @ApiOperation(value = "采购订单页面配置查询")
    @PostMapping(value = "/list")
    public Result getpurchaseOrderList() throws Exception{
        Map<String, Object> ipPurchaseOrderDto1=ipPurchaseOrderService.getpurchaseOrderList();
        return Result.ok(ipPurchaseOrderDto1);
    }

    @ApiOperation(value = "根据订单号查询订单详情")
    @PostMapping(value = "/getbyprocessnum")
    public Result getbyprocessnum(@RequestParam(value = "ordernum") String ordernum ) throws Exception{
        OrderGoodsDto orderGoodsDto=ipPurchaseOrderService.getbyprocessnum(ordernum);
        return Result.ok(orderGoodsDto);
    }
}
