package com.ekingwin.bas.cloud.purchase.web;

import com.ekingwin.bas.cloud.purchase.service.RequirementService;
import com.ekingwin.bas.cloud.purchase.vo.RequirementVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName RequirementController.java
 * @Description TODO
 * @createTime 2020/3/16 10:21
 */
@RestController
@RequestMapping(value = "/requirement/")
@Api(tags = "草稿箱", description = "草稿箱", value = "草稿箱")
public class RequirementController {
@Autowired
    private RequirementService requirementService;

    @ApiOperation(value = "草稿箱查询接口（高级查询）")
    @PostMapping(value = "/queryAllDrafts")
    public Result queryAllDrafts(@RequestBody RequirementVo requirementVo) throws Exception{
        PageInfo pageInfo=requirementService.queryAllDrafts(requirementVo);
        return Result.ok(pageInfo);
    }

    @ApiOperation(value = "草稿箱删除接口")
    @PostMapping(value = "/deletedrafts")
    public Result deletedrafts(@RequestBody RequirementVo requirementVo) throws Exception{
        Boolean result=requirementService.deletedrafts(requirementVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "下单失败查询接口（高级查询）")
    @PostMapping(value = "/orderFailList")
    public Result orderFailList(@RequestBody RequirementVo requirementVo) throws Exception{
        PageInfo pageInfo=requirementService.orderFailList(requirementVo);
        return Result.ok(pageInfo);
    }

    @ApiOperation(value = "删除下单失败记录")
    @PostMapping(value = "/orderFaildelete")
    public Result orderFaildelete(@RequestParam String id) throws Exception{
        Boolean result=requirementService.orderFaildelete(id);
        return Result.ok(result);
    }

    @ApiOperation(value = "订单接口记录（采购单接口记录列表接口）")
    @PostMapping(value = "/queryOrderList")
    public Result queryOrderList(@RequestBody RequirementVo requirementVo) throws Exception{
        PageInfo pageInfo=requirementService.queryOrderList(requirementVo);
        return Result.ok(pageInfo);
    }

    @ApiOperation(value = "采购单接口报文接口")
    @GetMapping(value = "/orderMessageDetails")
    public Result orderMessageDetails(@RequestParam String id) throws Exception{
        Map<String,Object> map=requirementService.orderMessageDetails(id);
        return Result.ok(map);
    }

    @ApiOperation(value = "采购单重发SRM接口（异常中。。。）")
    @GetMapping(value = "/orderRetransmission")
    public Result orderRetransmission(@RequestParam String id,String username) throws Exception{
       Map<String ,Object> map= requirementService.orderRetransmission(id,username);
        return Result.ok(map);
    }


}
