package com.ekingwin.bas.cloud.purchase.web;

import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformAddVo;
import com.ekingwin.bas.cloud.purchase.dto.SpecicalPurchaseDto;
import com.ekingwin.bas.cloud.purchase.service.SpecicalPurchaseService;
import com.ekingwin.bas.cloud.purchase.vo.ReplyGetOrderVo;
import com.ekingwin.bas.cloud.purchase.vo.ReplyOrderVo;
import com.ekingwin.bas.cloud.purchase.vo.SpecicalPurchaseVo;
import com.ekingwin.bas.cloud.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName SpecicalPurchaseController.java
 * @Description TODO
 * @createTime 2020/4/7 11:06
 */
@RestController
@RequestMapping(value = "/specicalPurchase/")
@Api(tags = "费用化及专项采购", description = "费用化及专项采购", value = "费用化及专项采购")
public class SpecicalPurchaseController {
    @Autowired
    private SpecicalPurchaseService specicalPurchaseService;

    @ApiOperation(value = "费用化及专项采购表单信息带出")
    @PostMapping(value = "/list")
    public Result getGoods(@RequestBody SpecicalPurchaseVo specicalPurchaseVo) throws Exception{
        SpecicalPurchaseDto specicalPurchaseDto =specicalPurchaseService.getGoods(specicalPurchaseVo);
        return Result.ok(specicalPurchaseDto);
    }

    @ApiOperation(value = "获取最新的订单编号")
    @GetMapping (value = "/getOrdernum")
    public Result getOrdernum() throws Exception{
        String ordernum =specicalPurchaseService.getOrdernum();
        return Result.ok(ordernum);
    }

    @ApiOperation(value = "费用化/专项采购,标准采购提交")
    @PostMapping(value = "/submit")
    public Result submit(@RequestBody PurchasingPlatformAddVo purchasingPlatformAddVo) throws Exception{
        return specicalPurchaseService.submit(purchasingPlatformAddVo);
    }

    @ApiOperation(value = "采购审批回写审批意见(该接口作废)")
    @PostMapping(value = "/replysubmit")
    public Result replysubmit(@RequestParam Map<String,Object> map) throws Exception{
        return Result.ok(specicalPurchaseService.replysubmit(map));
    }

    @ApiOperation(value = "订单创建结果回传")
    @PostMapping(value = "/replycreateorder")
    public Result replycreateorder(@RequestBody ReplyOrderVo eplyOrderVo) throws Exception {
        return specicalPurchaseService.replycreateorder(eplyOrderVo);
    }

    @ApiOperation(value = "收货状态回传(标准采购专用)")
    @PostMapping(value = "/replygetgoods")
    public Result replygetgoods(@RequestBody ReplyGetOrderVo replyGetOrderVo) throws Exception{
        return specicalPurchaseService.replygetgoods(replyGetOrderVo);
    }
}
