package com.ekingwin.bas.cloud.quartz.confirmgoods.service.impl;

import com.ekingwin.bas.cloud.dto.IpOrderReceiveGoodDto;
import com.ekingwin.bas.cloud.dto.IpOrderReceiverDto;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.quartz.confirmgoods.dao.ConfirmGoodsDao;
import com.ekingwin.bas.cloud.quartz.confirmgoods.service.ConfirmGoodsService;
import com.ekingwin.bas.cloud.service.IpOrderReceiverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * @ClassName: ConfirmGoodsServiceImpl
 * @Author: liujunfeng
 * @Date: 2019/11/3 21:02
 * @description:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class ConfirmGoodsServiceImpl implements ConfirmGoodsService {

    private Logger logger = LoggerFactory.getLogger(ConfirmGoodsServiceImpl.class);


    @Autowired
    ConfirmGoodsDao confirmGoodsDao;

    @Autowired
    IpOrderReceiverService orderReceiverService;


    @Override
    public String updateGoodsTask() {
        try {
            List<IpOrderReceiveGoodDto> goodDtoList = confirmGoodsDao.selectGoods();
            if (goodDtoList != null && goodDtoList.size() > 0) {
                List<IpOrderReceiveGoodDto> receiveGoodList = null;
                IpOrderReceiverDto ipOrderReceiverDto;
                for (IpOrderReceiveGoodDto goodDto : goodDtoList) {
                    receiveGoodList = new ArrayList<>();
                    ipOrderReceiverDto = new IpOrderReceiverDto();
                    ipOrderReceiverDto.setStatus(1);
                    receiveGoodList.add(goodDto);
                    ipOrderReceiverDto.setOrderType("GR");
                    ipOrderReceiverDto.setCustomerType("GR");
                    ipOrderReceiverDto.setGoods(receiveGoodList);
                    logger.info("ipOrderReceiverDto = " + ipOrderReceiverDto);
                    orderReceiverService.saveReceiver(ipOrderReceiverDto);
                }
            }
        } catch (Exception e) {
            throw new BusinessException(500, "任务执行失败");
        }
        return "任务执行成功";
    }

    @Override
    public String testQuartz() {
        String printTime = new SimpleDateFormat("yy-MM-dd HH:mm:ss").format(new Date());
        logger.info("任务执行：5秒执行111111111111111:" + printTime + ", 11111111111111111::" + new Random().nextInt(100));
        return printTime;
    }
}
