package com.ekingwin.bas.cloud.quartz.confirmgoods.web;

import com.ekingwin.bas.cloud.infra.utils.context.SpringUtils;
import com.ekingwin.bas.cloud.quartz.confirmgoods.service.ConfirmGoodsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @ClassName: ConfirmGoodsQuartz
 * @Author: liujunfeng
 * @Date: 2019/11/3 21:05
 * @description:
 */
@Component
public class ConfirmGoodsQuartz {

    private Logger logger = LoggerFactory.getLogger(ConfirmGoodsQuartz.class);


    @Scheduled(cron = "0 0 2-2 * * ?")//每天凌晨2点执行一次
    public void execute() {
        logger.info("定时收货任务----------------------开始执行---------------------------定时取消订单");
        ConfirmGoodsService goodsService  = (ConfirmGoodsService) SpringUtils.getApplicationContext().getBean("confirmGoodsServiceImpl");
        String str = goodsService.updateGoodsTask();
        logger.info("定时收货: " + str);
        logger.info("定时收货任务----------------------执行结束---------------------------定时取消订单");
    }

}
