package com.ekingwin.bas.cloud.quartz.orderTask.service.impl;

import com.ekingwin.bas.cloud.dto.OrderCancelDto;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.quartz.orderTask.dao.OrderTaskDao;
import com.ekingwin.bas.cloud.quartz.orderTask.service.OrderTaskService;
import com.ekingwin.bas.cloud.rabbit.sender.OrderCancelSender;
import com.ekingwin.bas.cloud.service.impl.IpcOrderServiceImpl;
import com.ekingwin.bas.cloud.vo.IpOrderGoodsDetailVo;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * @ClassName: OrderTaskServiceImpl
 * @Author: liujunfeng
 * @Date: 2019/11/3 15:38
 * @description:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class OrderTaskServiceImpl implements OrderTaskService{

    private Logger logger = LoggerFactory.getLogger(OrderTaskServiceImpl.class);

    @Autowired
    OrderTaskDao orderTaskDao;

    @Autowired
    IpcOrderServiceImpl orderService;

    @Autowired
    private OrderCancelSender orderCancelSender;


    @Override
    public String updateOrderTask() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = formatter.format(new Date());
        try {
            List<IpOrderGoodsDetailVo> goodsList = orderTaskDao.selectOrderTask(date);
            BigDecimal bigDecimal=new BigDecimal("-1");
            for (IpOrderGoodsDetailVo goods : goodsList){
                OrderCancelDto orderCancelDto = new OrderCancelDto();
                orderCancelDto.setOrderNo(goods.getOrdernum());
                String toString = JSONObject.fromObject(orderCancelDto).toString();
                //关闭二维码
                orderCancelSender.send("payment.order.cancel",toString);

                String goodsid = goods.getGoodsid().toString();
                String attrid = goods.getAttrid();
                BigDecimal count = goods.getCount().multiply(bigDecimal);
                //库存恢复
                orderService.deductionGoodsStock(goodsid,"GR",count.toString(),"fail",attrid);
            }
            orderTaskDao.updateOrderTask(date);
        }catch (Exception e){
            throw new BusinessException(500,"任务执行失败");
        }
        return "任务执行成功";
    }

    @Override
    public String testQuartz() {
        String printTime = new SimpleDateFormat("yy-MM-dd HH:mm:ss").format(new Date());
        logger.info("任务执行：10秒执行222222222222:" + printTime + ", 222222222222::" + new Random().nextInt(100));
        return printTime;
    }

}
