package com.ekingwin.bas.cloud.quartz.orderTask.web;

import com.ekingwin.bas.cloud.infra.utils.context.SpringUtils;
import com.ekingwin.bas.cloud.quartz.orderTask.service.OrderTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @ClassName: OrderTaskQuartz
 * @Author: liujunfeng
 * @Date: 2019/11/3 18:03
 * @description:
 */
@Component
public class OrderTaskQuartz {

    private Logger logger = LoggerFactory.getLogger(OrderTaskQuartz.class);

    @Scheduled(cron = "0 0/5 * * * ?")//每隔5分钟执行一次
    public void execute(){
        logger.info("订单到期改为已取消任务----------------------开始执行---------------------------定时取消订单");
        OrderTaskService orderTaskService  = (OrderTaskService) SpringUtils.getApplicationContext().getBean("orderTaskServiceImpl");
        String str = orderTaskService.updateOrderTask();
        logger.info("订单到期改为已取消: " + str);
        logger.info("订单到期改为已取消任务----------------------执行结束---------------------------定时取消订单");
    }

}
