package com.ekingwin.bas.cloud.quartz.reconciliationconfirm;

import com.ekingwin.bas.cloud.infra.utils.context.SpringUtils;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationConfirmDto;
import com.ekingwin.bas.cloud.monitor.service.WaitingReconciliationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @ClassName: ReconciliationConfirmQuartz
 * @Author: liujunfeng
 * @Date: 2019/12/19 10:50
 * @description:
 */
@Component
public class ReconciliationConfirmQuartz {

    private Logger logger = LoggerFactory.getLogger(ReconciliationConfirmQuartz.class);


    @Scheduled(cron = "0 0 0 26 * ? ")//每月26号凌晨执行一次
    public void execute() {
        logger.info("自动对账确认任务----------------------开始执行---------------------------自动对账确认任务");
        WaitingReconciliationService waitingReconciliationService = (WaitingReconciliationService) SpringUtils.getApplicationContext().getBean("waitingReconciliationServiceImpl");

        IpOrderReconciliationConfirmDto confirmDto = new IpOrderReconciliationConfirmDto();

        logger.info("XM订单自动对账确认任务----------开始执行");
        confirmDto.setOrderType("XM");
        try {
            waitingReconciliationService.confirmOrderWaiting(confirmDto);
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("XM订单自动对账确认任务----------执行失败:"+e);
        }
        logger.info("XM订单自动对账确认任务----------执行结束");


        logger.info("GR订单自动对账确认任务----------开始执行");
        confirmDto.setOrderType("GR");
        try {
            waitingReconciliationService.confirmOrderWaiting(confirmDto);
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("GR订单自动对账确认任务----------执行失败:"+e);
        }
        logger.info("GR订单自动对账确认任务----------执行结束");

        logger.info("自动对账确认任务----------------------执行结束---------------------------自动对账确认任务");
    }


}
