package com.ekingwin.bas.cloud.rabbit.receiver;

import com.ekingwin.bas.cloud.dto.IpAgreementProcessDto;
import com.ekingwin.bas.cloud.service.IpAgreementProcessService;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName: AgreementProcessReceiver
 * @Author: liujunfeng
 * @Date: 2019/12/4 16:28
 * @description:
 */
@Component
@RabbitListener(bindings = @QueueBinding(
        value = @Queue(value = "${rabbitmq.receiver.agreement}", autoDelete = "true"),
        exchange = @Exchange(value = "${rabbitmq.exchange.agreement}", type = ExchangeTypes.TOPIC),
        key = "*.agreement.info"
))
public class AgreementProcessReceiver {

    private Logger logger = LoggerFactory.getLogger(AgreementProcessReceiver.class);


    @Autowired
    IpAgreementProcessService agreementProcessService;


    @RabbitHandler
    public void saveSuppliers(String msg) throws Exception {
        logger.info(msg);
        try{
            JSONObject jsonObject = JSONObject.fromObject(msg);
            IpAgreementProcessDto processDto= (IpAgreementProcessDto)JSONObject.toBean(jsonObject,IpAgreementProcessDto.class);
            agreementProcessService.startAgreement(processDto);
        }catch (Exception e){
                e.printStackTrace();
        }

    }


}
