package com.ekingwin.bas.cloud.rabbit.receiver;

import com.ekingwin.bas.cloud.dto.OrderPaymentResultDto;
import com.ekingwin.bas.cloud.service.IpcOrderService;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-24 17:43
 **/
@Component
@RabbitListener(bindings = @QueueBinding(
        value = @Queue(value = "${rabbitmq.receiver.paymentResult}", autoDelete = "true"),
        exchange = @Exchange(value = "${rabbitmq.exchange.payment}", type = ExchangeTypes.TOPIC),
        key = "*.payment.result"
))
public class PaymentReceiver {

    private Logger logger = LoggerFactory.getLogger(PaymentReceiver.class);

    @Autowired
    private IpcOrderService ipcOrderService;

    @RabbitHandler
    public void paymentResult(String msg){
        try {
            JSONObject jsonObject = JSONObject.fromObject(msg);
            OrderPaymentResultDto payment= (OrderPaymentResultDto)JSONObject.toBean(jsonObject,OrderPaymentResultDto.class);
            logger.info(payment.getId());
            ipcOrderService.updateOrderPayemntResult(payment);
        }catch (Exception e){
            e.printStackTrace();
        }

    }
}
