package com.ekingwin.bas.cloud.rabbit.receiver;

import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationVo;
import com.ekingwin.bas.cloud.service.IpOrderReconciliationRecordService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Administrator
 */

@Component
@RabbitListener(bindings = @QueueBinding(
        value = @Queue(value = "${rabbitmq.moitor.receiver.confirmmonitororder}", autoDelete = "true"),
        exchange = @Exchange(value = "${rabbitmq.moitor.exchange.confirmmonitororder}", type = ExchangeTypes.TOPIC),
        key = "confirm.confirmmonitororder.info"
))
public class ReconciliationConfirmOrderReceiver {

    private Logger logger = LoggerFactory.getLogger(ReconciliationConfirmOrderReceiver.class);

    @Autowired
    IpOrderReconciliationRecordService recordService;



    @RabbitHandler
    public void saveOrder(String msg) throws Exception{
        logger.info(msg+"11111111111122222222222");
        try{
            JSONObject jsonObject = JSONObject.fromObject(msg);
            if (jsonObject !=null && jsonObject.size()>0){
                List<IpOrderReconciliationVo> orderReconciliationVos = new ArrayList<>();
                Iterator iterator = jsonObject.keys();
                while(iterator.hasNext()){
                    String key = (String) iterator.next();
                    String value = jsonObject.getString(key);
                    JSONArray jsonArray = JSONArray.fromObject(value);
                    if (jsonArray !=null && jsonArray.size()>0){
                        for (Object object : jsonArray) {
                            JSONObject jsonObject1=(JSONObject)object;
                            IpOrderReconciliationVo orderReconciliationDto = (IpOrderReconciliationVo)JSONObject.toBean(jsonObject1, IpOrderReconciliationVo.class);
                            orderReconciliationVos.add(orderReconciliationDto);
                        }
                    }
                }
                recordService.saveReconciliation(orderReconciliationVos);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

    }
}
