package com.ekingwin.bas.cloud.rabbit.receiver;

import com.ekingwin.bas.cloud.dto.sapmessage.SapInvoiceReturnDto;
import com.ekingwin.bas.cloud.service.IpInvoiceService;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName: SapInvoiceReturnReceiver
 * @Author: liujunfeng
 * @Date: 2019/12/4 16:28
 * @description:
 */
@Component
@RabbitListener(bindings = @QueueBinding(
        value = @Queue(value = "${rabbitmq.receiver.sapinvoicereturn}", autoDelete = "true"),
        exchange = @Exchange(value = "${rabbitmq.exchange.sapinvoicereturn}", type = ExchangeTypes.TOPIC),
        key = "*.sapinvoicereturn.info"
))
public class SapInvoiceReturnReceiver {

    private Logger logger = LoggerFactory.getLogger(SapInvoiceReturnReceiver.class);


    @Autowired
    IpInvoiceService invoiceService;


    @RabbitHandler
    public void saveInvoice(String msg) throws Exception {
        logger.info(msg);
        try{
            JSONObject jsonObject = JSONObject.fromObject(msg);
            SapInvoiceReturnDto invoiceReturnDto= (SapInvoiceReturnDto)JSONObject.toBean(jsonObject,SapInvoiceReturnDto.class);
            invoiceService.sapInvoiceReturn(invoiceReturnDto);
        }catch (Exception e){
            e.printStackTrace();
        }

    }


}
