package com.ekingwin.bas.cloud.rabbit.receiver;

import com.ekingwin.bas.cloud.dto.sapmessage.PaymentInfosDto;
import com.ekingwin.bas.cloud.dto.sapmessage.PaymentPayAppItemInfoDto;
import com.ekingwin.bas.cloud.dto.sapmessage.SapPaymentReturnDto;
import com.ekingwin.bas.cloud.service.IpPaymentService;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName: SapPaymentReturnReceiver
 * @Author: liujunfeng
 * @Date: 2019/12/4 16:28
 * @description:
 */
@Component
@RabbitListener(bindings = @QueueBinding(
        value = @Queue(value = "${rabbitmq.receiver.sappaymentreturn}", autoDelete = "true"),
        exchange = @Exchange(value = "${rabbitmq.exchange.sappaymentreturn}", type = ExchangeTypes.TOPIC),
        key = "*.sappaymentreturn.info"
))
public class SapPaymentReturnReceiver {
    private Logger logger = LoggerFactory.getLogger(SapPaymentReturnReceiver.class);


    @Autowired
    IpPaymentService paymentService;


    @RabbitHandler
    public void savePayment(String msg) throws Exception {
        logger.info(msg);
        try{
            JSONObject jsonObject = JSONObject.fromObject(msg);
            Map<String, Class<?>> classMap = new HashMap<String, Class<?>>();
            classMap.put("payAppItemInfo", PaymentPayAppItemInfoDto.class);
            classMap.put("invInfos", PaymentInfosDto.class);
            SapPaymentReturnDto paymentReturnDto = (SapPaymentReturnDto) JSONObject.toBean(jsonObject, SapPaymentReturnDto.class, classMap);
            paymentService.sapPaymentReturn(paymentReturnDto);
        }catch (Exception e){
            e.printStackTrace();
        }

    }


}
