package com.ekingwin.bas.cloud.rabbit.sender;

import com.ekingwin.bas.cloud.config.RabbitExchangeConfig;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-11-02 15:03
 **/
@Component
public class GoodsSender {

    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Autowired
    private RabbitExchangeConfig rabbitExchange;


    /**
     *
     * @Param:
     *
     * @param sendConfig
     *@param jsonStr 参数
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/24 17:13
     */
    public void send(String sendConfig,String jsonStr)
            throws InterruptedException {
        try {
            String  exchange=rabbitExchange.getGoods();
            rabbitTemplate.convertAndSend(exchange,sendConfig,jsonStr);
        }catch (Exception e){
            e.printStackTrace();
        }

    }
}
