package com.ekingwin.bas.cloud.rabbit.sender;

import com.ekingwin.bas.cloud.config.RabbitExchangeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderReceiverSender {

    private Logger logger = LoggerFactory.getLogger(OrderReceiverSender.class);

    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Autowired
    private RabbitExchangeConfig rabbitExchange;

    /**
     *
     * @Param:
     *
     * @param sendConfig
     *@param jsonStr 参数
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/24 17:13
     */
    public void send(String sendConfig,String jsonStr)
            throws InterruptedException {
        try {
            String  exchange=rabbitExchange.getSaporderreceiver();
            logger.info("推送："+jsonStr);
            rabbitTemplate.convertAndSend(exchange,sendConfig,jsonStr);
        }catch (Exception e){
            e.printStackTrace();
        }

    }
}
