package com.ekingwin.bas.cloud.rabbit.sender;

import com.ekingwin.bas.cloud.config.RabbitExchangeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessSender {

    private Logger logger = LoggerFactory.getLogger(ProcessSender.class);


    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Autowired
    private RabbitExchangeConfig rabbitExchange;


    public void send(String sendConfig,String jsonStr)
            throws InterruptedException {
        try {
            String  exchange=rabbitExchange.getSapgoods();
            logger.info(jsonStr+"<<<<<<<<<<<<<<<"+exchange);
            rabbitTemplate.convertAndSend(exchange,sendConfig,jsonStr);
        }catch (Exception e){
            e.printStackTrace();
        }

    }
}
