package com.ekingwin.bas.cloud.reqno.dao;


import com.ekingwin.bas.cloud.reqno.dao.entity.Reqno;
import com.ekingwin.bas.mapper.BasMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;

/**
 * @author Jie
 */
@Repository
public interface IReqnoDao extends BasMapper<Reqno> {
	
	@Lock(value = LockModeType.PESSIMISTIC_WRITE)
	Reqno getReqNo(@Param("noKey") String noKey, @Param("year") String year);


	void createNewRequestNo(Reqno reqno);

	void updateRequestNo(Reqno reqno);
}


