package com.ekingwin.bas.cloud.reqno.service.impl;


import com.ekingwin.bas.cloud.reqno.dao.IReqnoDao;
import com.ekingwin.bas.cloud.reqno.dao.entity.Reqno;
import com.ekingwin.bas.cloud.reqno.service.IReqnoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Date;

@Primary
@Service
public class ReqnoServiceImpl implements IReqnoService {


	@Autowired
	private IReqnoDao reqnoDao;

	@Override
	@Transactional(propagation= Propagation.REQUIRES_NEW)
	public Reqno getRequestNoIndexNoByProcessIdWithLock(String processName,
														String format,String firstKey) {
		SimpleDateFormat sdf = new SimpleDateFormat(format);
	    String year = sdf.format(new Date());

	    Reqno entity = this.reqnoDao.getReqNo(processName,year);
	    if (entity == null){
	    	Reqno reqno=new Reqno();
			reqno.setNoKey(processName);
			reqno.setDatevalues(year);
			reqno.setCurrentindex(0L);
			reqno.setFirstKey(firstKey);
			this.reqnoDao.createNewRequestNo(reqno);
		}


	    entity = this.reqnoDao.getReqNo(processName,year);
	    Long currentIndex = entity.getCurrentindex();
	    entity.setCurrentindex(Long.valueOf(currentIndex.longValue() + 1L));

	    this.reqnoDao.updateRequestNo(entity);
	    return entity;
	}
	
}
