package com.ekingwin.bas.cloud.reqno.utils;


import com.ekingwin.bas.cloud.infra.utils.context.SpringUtils;
import com.ekingwin.bas.cloud.reqno.dao.entity.Reqno;
import com.ekingwin.bas.cloud.reqno.service.IReqnoService;
import org.apache.commons.lang.StringUtils;

public class GenerateRequestCode {


    /**
     * 时间格式(yyyy)
     */
    public static String YEAR         = "yyyy";
    /**
     * 时间格式(yyyy)
     */
    public static String YEARMONTH    = "yyyyMM";
    /**
     * 时间格式(yyyyMMdd)
     */
    public static String YEARMONTHDAY = "yyyyMMdd";

    public static String generateRequestCode(Long num, int bit) {
        String baseChar = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-";
        String numStr = String.format("%1$0" + bit + "d", new Object[]{num});
        String right3 = StringUtils.right(numStr, bit - 1);
        String left = StringUtils.left(numStr, numStr.length() - (bit - 1));
        String left36 = StringUtils.mid(baseChar, Integer.valueOf(left).intValue(), 1);
        return left36 + right3;
    }

    /**
     * 生成单号
     *
     * @param processName 流程英文名称
     * @param format      格式：yyyy/yyyyMM/yyyyMMdd
     * @param bit         位数，比如 20190008 ： yyyy + 4位 ；此时传4即可
     * @return
     */
    public static String requestCode(String processName, String format, int bit,String firstKey) {
        IReqnoService reqnoService = (IReqnoService) SpringUtils.getBean("reqnoServiceImpl");
        Reqno reqNo = reqnoService.getRequestNoIndexNoByProcessIdWithLock(processName, format,firstKey);
        String currentIndex = generateRequestCode(reqNo.getCurrentindex(), bit);
        String code =reqNo.getDatevalues() + currentIndex;
        if (StringUtils.isNotEmpty(reqNo.getFirstKey())){
            code=reqNo.getFirstKey()+code;
        }
        return code;
    }

    public static void main(String[] args) {
        System.out.println(generateRequestCode(1L, 3));
        System.out.println(generateRequestCode(1L, 5));
        System.out.println(generateRequestCode(111L, 3));
        System.out.println(generateRequestCode(111L, 5));
        System.out.println(generateRequestCode(3123L, 3));
        System.out.println(generateRequestCode(312221L, 5));
    }

}

