package com.ekingwin.bas.cloud.reqno.web;

import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.utils.common.ResultUtils;
import com.ekingwin.bas.cloud.reqno.service.IReqnoService;
import com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/bpm/reqno")
@Api(tags = "申请单号相关Api",value = "申请单号相关Api")
public class ReqnoController {

	@Autowired
	@Qualifier("reqnoServiceImpl")
	private IReqnoService reqnoService;


	@ApiOperation("测试生成单号信息")
	@RequestMapping(value = "/test/{processName}/{format}/{bit}/{firstKey}", method = RequestMethod.GET)
    public BaseResult<String> get(@PathVariable(value="processName") String processName,
								  @PathVariable(value="format") String format,
								  @PathVariable(value="bit")int bit,
								  @PathVariable(value = "firstKey")String firstKey) throws Exception {
		return ResultUtils.build(GenerateRequestCode.requestCode(processName, format, bit,firstKey));
    }
	
	


}
