package com.ekingwin.bas.cloud.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import java.util.concurrent.Future;


/**
 * @author 许世文
 * @Date 2019/8/5 16:11
 * @Version 1.0
 **/
@Component
public class AsyncService {

    private Logger logger = LoggerFactory.getLogger(AsyncService.class);


    @Autowired
    private ImailService imailService;
    @Value("${sendDeliverMailSwitch}")
    private String mailSwitch;

    /**
     * 根据订单号查询商品发送邮件
     * @param orderNum
     */
    @Async
    public Future<String> sendMailTask(String orderNum){
        logger.info("------------异步发送发货通知邮件---------");
        try{
           if(mailSwitch.equals("true")){
               Thread.sleep(10000);
               logger.info(orderNum);
               imailService.sendDeliverMail(orderNum);
           }
        }catch (Exception e){
            logger.info("邮件发送失败");
            logger.error(e.getMessage());
        }
        return new AsyncResult<>("邮件发送成功");
    }

}
