package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpCustAddressDto;
import com.ekingwin.bas.cloud.dto.IpOrderAddressDto;
import com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo;
import com.github.pagehelper.PageInfo;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-25 13:40
 **/
public interface IpCustAddressService {


    /**
    * 保存地址
    * @Param:  * @param ipCustAddressDto
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/25 14:18
    */
    void  saveCustAdderss(IpCustAddressDto ipCustAddressDto) throws Exception;

    /**
    * 获取所有的地址
    * @Param:  * @param orderAddressDto
    * @return: com.github.pagehelper.PageInfo<com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo>
    * @Author: zhangjie
    * @Date: 2019/10/25 14:26
    */
    PageInfo<IpCustOrderAddressVo> getCustAddress(IpOrderAddressDto orderAddressDto);



    /**
    * 地址删除
    * @Param:  * @param id
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 15:10
    */
    int deleteCustAddress(Long id);



    /**
    * 设置默认地址
    * @Param:  * @param id
     * @param userId
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 15:11
    */
    int defaultCustAddress(Long id,String userId);



    /**
    * 获取默认地址
    * @Param:  * @param userId
    * @return: com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo
    * @Author: zhangjie
    * @Date: 2019/10/25 16:24
    */
    IpCustOrderAddressVo getCustAddress(String userId);

}
