package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpInvoiceDto;
import com.ekingwin.bas.cloud.dto.IpInvoicePageDto;
import com.ekingwin.bas.cloud.dto.IpPurchasesDto;
import com.ekingwin.bas.cloud.dto.sapmessage.SapInvoiceReturnDto;
import com.ekingwin.bas.cloud.vo.IpInvoiceLsitVo;
import com.ekingwin.bas.cloud.vo.IpPaymentApplyVo;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface IpInvoiceService {

    /**
     * 发票记录列表
     * @param invoicePageDto
     * @return
     */
    PageInfo<IpInvoiceLsitVo> getInvoiceLsit(IpInvoicePageDto invoicePageDto);

    /**
     * 发票记录详情
     * @param invoicePageDto
     * @return
     */
    IpInvoiceDto getInvoice(IpInvoicePageDto invoicePageDto);

    /**
     * 新增发票记录
     * @param invoiceDto
     * @return
     * @throws Exception
     */
    String saveInvoice(IpInvoiceDto invoiceDto)throws Exception;


    /**
     * 发票记录列表Excel导出
     * @param response
     * @param ipInvoicePageDto
     * @throws Exception
     */
    void getExcel(HttpServletResponse response, IpInvoicePageDto ipInvoicePageDto) throws Exception;

    /**
     * SAP发票返回状态
     * @param invoiceReturnDto
     */
    void sapInvoiceReturn(SapInvoiceReturnDto invoiceReturnDto);

    /**
     * 零星采购
     * @param purchasesDto
     * @return
     * @throws Exception
     */
    List<IpPaymentApplyVo> getRetailPurchasesList(IpPurchasesDto purchasesDto)throws Exception;

    /**
     * 工程采购
     * @param purchasesDto
     * @return
     * @throws Exception
     */
    IpPaymentApplyVo getEngineeringPurchasesList(IpPurchasesDto purchasesDto)throws Exception;


}
