package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.vo.IpDeliverLogisticsVo;
import com.ekingwin.bas.cloud.vo.IpOrderDeliverVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

public interface IpOrderDeliverService {


    /**
     * 保存送货单信息
     * @param ipOrderDeliverDto
     * @return
     * @throws Exception
     */
    Long saveOrUpdateDeliver(IpOrderDeliverDto ipOrderDeliverDto) throws  Exception;


    /**
     * 获取送货单信息
     * @param ipOrderDeliverListDto
     * @return
     */
    PageInfo getOrderDeliverList(IpOrderDeliverListDto ipOrderDeliverListDto);


    /**
     * 保存物流信息
     * @param ipOrderDeliverLogisticsDto
     * @return
     * @throws Exception
     */
    int  saveOrUpdateLogistics(IpOrderDeliverLogisticsDto ipOrderDeliverLogisticsDto) throws Exception;

    /**
     * 根据订单id查询订单信息
     * @param ipOrderDeliverSearchDto
     * @return
     */
    IpOrderDeliverVo getDeliverDetail(IpOrderDeliverSearchDto ipOrderDeliverSearchDto);

    /**
     * 根据订单号和商品编号获取信息
     * @param ipOrderLogisticsSearchDto
     * @return
     */
    List<IpOrderDeliverVo> getOrderDeliverByOrderNum(IpOrderLogisticsSearchDto ipOrderLogisticsSearchDto);


    /**
     * 保存物流信息
     * @param detail
     * @param deliverId
     * @param userId
     * @param userName
     */
    void saveLogistic(String detail, Long deliverId, String userId, String userName);


    /**
     * 修改送货单状态
     * @param status
     * @param deliverId
     * @return
     */
    int updateStatus(String status,Long deliverId);


    /**
     * 修改收货的数量
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsStatus(IpOrderGoodsStatusDto  ipOrderGoodsStatusDto);


    /**
     * 获取数据
     * @param ipOrderDeliverSearchDto
     * @return
     */
    IpOrderDeliverVo getDeliverDetailMobile(IpOrderDeliverSearchDto ipOrderDeliverSearchDto);

    /**
    * 修改个人收货确认修改发货单商品状态
    * @Param:  * @param list
     * @param status
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/15 14:41
    */
    void updateGrDeliverGoodsStatus(List<IpOrderReceiveGoodDto> list,String status);


    /**
    * 获取物流信息
    * @Param:  * @param logisticsNum
    * @return: java.util.List<com.ekingwin.bas.cloud.vo.IpDeliverLogisticsVo>
    * @Author: zhangjie
    * @Date: 2019/10/28 17:59
    */
    List<IpDeliverLogisticsVo> getLogistics(String logisticsNum);
}
