package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpOrderReceiverDto;
import com.ekingwin.bas.cloud.dto.IpOrderReceiverSearchDto;
import com.ekingwin.bas.cloud.entity.IpOrderReceive;
import com.ekingwin.bas.cloud.vo.IpOrderReceiverVo;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-07 15:36
 **/
public interface IpOrderReceiverService {


    /**
     * 保存收货信息
     * @param ipOrderReceiverDto
     * @return
     */
    String saveReceiver (IpOrderReceiverDto ipOrderReceiverDto) throws Exception;


    /**
     * 获取发货单详情
     * @param ipOrderReceiverSearchDto
     * @return
     */
    IpOrderReceiverVo getOrderReceiverData(IpOrderReceiverSearchDto ipOrderReceiverSearchDto);

    /**
     * 流程审批通过过
     * @param instid
     */
    void initPass(String instid) throws Exception;

    /**
     * 流程审批不通过
     * @param instid
     */
    void initFail(String instid);


    /**
    * 初始化订单号
    * @Param:  * @param ipOrderReceiverDto
     * @param receiverNum
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/31 16:56
    */
    void initReceiverInvoice(IpOrderReceiverDto ipOrderReceiverDto,String receiverNum) throws Exception;


    /**
     *  同步sap
     * @param ipOrderReceive
     * @throws Exception
     */
    void initSapReceiver(IpOrderReceive ipOrderReceive) throws Exception;
}
