package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpOrderReconciliationRecordPageDto;
import com.ekingwin.bas.cloud.entity.IpOrderReconciliationRecord;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationVo;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface IpOrderReconciliationRecordService {

    /**
     * 新增对账单记录
     * @param orderReconciliationVos
     */
    void saveReconciliation(List<IpOrderReconciliationVo> orderReconciliationVos) throws Exception;


    /**
     * 查询对账单列表
     * @param recordPageDto
     * @return
     * @throws Exception
     */
    PageInfo<IpOrderReconciliationRecord> getReconciliationRecordList(IpOrderReconciliationRecordPageDto recordPageDto) throws Exception;


    /**
     * 确认对账单
     * @param recordDto
     */
    void updateReconciliationOrderStatus(IpOrderReconciliationRecordPageDto recordDto)throws Exception;


    /**
     * 对账单列表 Excel导出
     * @param ipOrderReconciliationRecordPageDto
     * @param response
     * @throws Exception
     */
    void getExcel(IpOrderReconciliationRecordPageDto ipOrderReconciliationRecordPageDto, HttpServletResponse response)throws Exception;
}
