package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpOrderRejectGoodsConfirmDto;
import com.ekingwin.bas.cloud.dto.IpOrderRejectSearchDto;
import com.ekingwin.bas.cloud.dto.IpOrderRejectedGoodsDto;
import com.ekingwin.bas.cloud.vo.IpOrderRejectedVo;
import com.github.pagehelper.PageInfo;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-16 14:39
 **/
public interface IpOrderRejectedService {

    /**
    *保存退货单数据
    * @Param:  * @param ipOrderRejectedGoodsDto
    * @return: java.lang.Long
    * @Author: zhangjie
    * @Date: 2019/10/16 16:03
    */
    Long saveReject(IpOrderRejectedGoodsDto ipOrderRejectedGoodsDto) throws Exception;



    /**
    * 查询退货单列表
    * @Param:  * @param ipOrderRejectSearchDto
    * @return: com.github.pagehelper.PageInfo<com.ekingwin.bas.cloud.vo.IpOrderRejectedVo>
    * @Author: zhangjie
    * @Date: 2019/10/16 18:03
    */
    PageInfo<IpOrderRejectedVo> getOrderRejectedList(IpOrderRejectSearchDto ipOrderRejectSearchDto) throws Exception;



    /**
    * 退货确认
    * @Param:  * @param goodsConfirmDto
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/26 17:10
    */
    void  updateRejectGoodsConfim(IpOrderRejectGoodsConfirmDto goodsConfirmDto) throws Exception;



    /**
    * 获取退货单详情
    * @Param:  * @param rejectedId
    * @return: com.ekingwin.bas.cloud.vo.IpOrderRejectedVo
    * @Author: zhangjie
    * @Date: 2019/10/28 18:03
    */
    IpOrderRejectedVo getOrderRejectedDetail(String rejectedId)
            throws Exception;
}
