package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpOrderReportDto;
import com.ekingwin.bas.cloud.dto.IpOrderSupplierHomeDto;
import com.ekingwin.bas.cloud.vo.IpOrderSupplierHomeDayVo;
import com.ekingwin.bas.cloud.vo.IpOrderSupplierHomeVo;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-23 10:50
 **/
public interface IpOrderReportService {


    /**
     * 获取所有的订单列表
     * @param ipOrderReportDto
     * @return
     */
    PageInfo getOrderReport( IpOrderReportDto ipOrderReportDto);


    /**
     * 获取供应商首页统计数据
     * @param ipOrderSupplierHomeDto
     * @return
     */
    IpOrderSupplierHomeVo getSupplierHome(IpOrderSupplierHomeDto ipOrderSupplierHomeDto);


    /**
     * 获取供应商七日
     * @param supplierid
     * @return
     */
    List<IpOrderSupplierHomeDayVo> getSupplierDay(String supplierid);

    //导出报表
    void getExcel(IpOrderReportDto ipOrderReportDto, HttpServletResponse response)throws Exception;


}
