package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpPaymentDto;
import com.ekingwin.bas.cloud.dto.IpPaymentPageDto;
import com.ekingwin.bas.cloud.dto.IpPaymentPayInfoDto;
import com.ekingwin.bas.cloud.dto.IpPurchasesDto;
import com.ekingwin.bas.cloud.dto.sapmessage.SapPaymentReturnDto;
import com.ekingwin.bas.cloud.vo.IpPaymentApplyVo;
import com.ekingwin.bas.cloud.vo.IpPaymentContractVo;
import com.ekingwin.bas.cloud.vo.IpPaymentVo;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Repository;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Repository
public interface IpPaymentService {


    /**
     * 获取 付款单列表信息
     * @param ipPaymentPageDto
     * @return
     * @throws Exception
     */
     PageInfo<IpPaymentVo> getPaymentInfo(IpPaymentPageDto ipPaymentPageDto)throws Exception;

    /**
     * 保存和更新
     * @param ipPaymentDto
     * @return
     * @throws Exception
     */
    String saveOrUpdatePaymen(IpPaymentDto ipPaymentDto)throws Exception;


    /**
     * 查询付款单详细信息
     * @param ipPaymentPageDto
     * @return
     * @throws Exception
     */
    IpPaymentDto queryPayment(IpPaymentPageDto ipPaymentPageDto)throws Exception;


    /**
     * 付款单列表 Excel导出
     * @param ipPaymentPageDto
     * @param response
     * @throws Exception
     */
    void getExcel(IpPaymentPageDto ipPaymentPageDto, HttpServletResponse response)throws Exception;

    /**
     * SAP付款申请(修改后)返回
     * @param paymentReturnDto
     */
    void sapPaymentReturn(SapPaymentReturnDto paymentReturnDto);


    /**
     * 查询sap返回的 付款明细
     * @param payInfoDto
     * @return
     * @throws Exception
     */
    PageInfo<IpPaymentPayInfoDto> sapDetailList(IpPaymentPayInfoDto payInfoDto)throws Exception;


    /**
     * 合同选择
     * @param payInfoDto
     * @return
     * @throws Exception
     */
    PageInfo<IpPaymentContractVo> getContractChoice(IpPaymentPayInfoDto payInfoDto)throws Exception;

    /**
     * 对账单选择
     * @param payInfoDto
     * @return
     * @throws Exception
     */
    List<String> getReconciliationChoice(IpPaymentPayInfoDto payInfoDto)throws Exception;

    /**
     * 零星采购
     * @param purchasesDto
     * @return
     * @throws Exception
     */
    List<IpPaymentApplyVo> getRetailPurchasesList(IpPurchasesDto purchasesDto)throws Exception;

    /**
     * 工程采购
     * @param purchasesDto
     * @return
     * @throws Exception
     */
    IpPaymentApplyVo getEngineeringPurchasesList(IpPurchasesDto purchasesDto)throws Exception;


}
