package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.BasePageDto;
import com.ekingwin.bas.cloud.dto.IpProjectSearchDto;
import com.ekingwin.bas.cloud.dto.IpProjectUserDto;
import com.ekingwin.bas.cloud.entity.IpProjectUser;
import com.ekingwin.bas.cloud.vo.IpProjectStagesUserVo;
import com.ekingwin.bas.cloud.vo.IpProjectStagesVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-29 17:39
 **/
public interface IpProjectService {


    /**
     * 查询项目
     * @param ipProjectSearchDto
     * @return
     */
    PageInfo getProject(IpProjectSearchDto ipProjectSearchDto);



    List<IpProjectStagesVo> getStages(IpProjectSearchDto ipProjectSearchDto);

    /**
     * 查询项目分期下的收货方信息
     * @param ipProjectUserDto
     * @return
     */
    PageInfo getProjectReceiverUser(IpProjectUserDto ipProjectUserDto) throws Exception;

    /**
     * 新增或者修改收货方信息
     */
    int insertOrUpdateReceiverUser(IpProjectUserDto ipProjectUserDto) throws Exception;

    /**
     * 删除收货方信息(逻辑删除)
     */
    int deleteReceiverUser(IpProjectUserDto ipProjectUserDto) throws Exception;


    /**
     * 获取收货人信息
     * @param ipProjectSearchDto
     * @return
     */
    List<IpProjectStagesUserVo> getStagesUser(IpProjectSearchDto ipProjectSearchDto);

}
