package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpCarSearchDto;
import com.ekingwin.bas.cloud.dto.IpCarUpdateDto;
import com.ekingwin.bas.cloud.dto.IpCartDeleteDto;
import com.ekingwin.bas.cloud.dto.IpcCartDto;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpCarDetailVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-02 10:38
 **/
public interface IpcCartService {


    /**
     * 批量购物车
     * @param carIds
     */
    void deleteCart(String carIds);


    /**
     * 获取购物车数量
     * @param ipCarSearchDto
     * @return
     */
    int getCarCount(IpCarSearchDto ipCarSearchDto);


    /**
     * 加入购物车
     * @param ipcCartDto
     * @throws Exception
     */
    void saveCar(IpcCartDto ipcCartDto) throws Exception;


    /**
     * 查询购物车商品列表
     * @param ipCarSearchDto
     * @return
     */
    List<IpCarDetailVo> getCarGoodsList(IpCarSearchDto ipCarSearchDto);


    /**
     * 清空购物车
     * @param ipCartDeleteDto
     */
    void deleCar(IpCartDeleteDto ipCartDeleteDto);


    /**
     * 修改购物车的数量与价格
     * @param ipCarUpdateDto
     */
    void  updateCar(IpCarUpdateDto ipCarUpdateDto) throws Exception;



    /**
    * 校验库存
    * @Param:  * @param goodsId
     * @param count
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/28 10:40
    */
    Result checkGoodsStock(String goodsId, String count, BigDecimal ocount, String attrid) throws Exception;


    /**
    * 查询购物车数量
    * @Param:  * @param carIds
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/11/6 20:13
    */
    int selectCarIds(String carIds);
}
