package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.entity.IpcOrder;
import com.ekingwin.bas.cloud.entity.IpcOrderAllgoods;
import com.ekingwin.bas.cloud.vo.*;
import com.github.pagehelper.PageInfo;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-02 10:38
 **/
public interface IpcOrderService {


    /**
     * 保存订单信息
     * @param ipOrderAddDto
     * @return
     * @throws Exception
     */
    IpOrderResultVo saveOrUpdateOrder(IpOrderAddDto ipOrderAddDto) throws Exception;


    /**
     * 获取订单数据
     * @param ipOrderDetailDto
     * @return
     * @throws Exception
     */
    IpOrderCarDetailVo getOrderCarDetail(IpOrderDetailDto ipOrderDetailDto) throws Exception;


    /**
     * 获取我的订单列表
     * @param IpOrderMyListVo
     * @return
     */
//    PageInfo getOrderListByUserId(IpOrderSearchDto ipOrderSearchDto);
    PageInfo getOrderListByUserId(IpOrderMyListVo ipOrderMyListVo);


    /**
     * 扣减发货数量
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsStatus(IpOrderGoodsStatusDto ipOrderGoodsStatusDto);


    /**
     * 扣减收货数量修改状态
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsStatus1(IpOrderGoodsStatusDto ipOrderGoodsStatusDto);


    /**
     * 更新流程实例号
     * @param instidDto
     * @return
     */
    int updateOrderBpmId(IpOrderInstidDto instidDto);


    /**
     * 审批通过状态
     * @param instid
     */
    void updatePassStatus(String instid)  throws Exception;

    /**
     * 审批不通过状态
     * @param instid
     */
    void updateFailStatus(String instid)  throws Exception;


    /**
     * 修改已发货数量
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsDeliverCount(IpOrderGoodsStatusDto ipOrderGoodsStatusDto);


    /**
     * 订单取消
     * @param orderCancelDto
     * @throws Exception
     */
    void  orderCancel(OrderCancelDto orderCancelDto) throws Exception;


    /**
     * 获取商品的收货数量
     * @param orderGoodsId
     * @return
     */
    BigDecimal getReceiverGoods(String orderGoodsId);

    /**
     * 获取商品的发货数量
     * @param orderGoodsId
     * @return
     */
    BigDecimal getDeliverGoods(String orderGoodsId);



    /**
    * 修改收货数量
    * @Param:  * @param goods
    * @return: int
    */
    int updateGoodsReceiverList(List<IpOrderReceiveGoodDto> goods);


    /**
    * 获取地址
    * @Param:  * @param orderAddressDto
    * @return: com.github.pagehelper.PageInfo<com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo>
    * @Author: zhangjie
    * @Date: 2019/10/22 16:41
    */
    PageInfo<IpCustOrderAddressVo> getCustAddress(IpOrderAddressDto orderAddressDto);


    /**
    * 修改支付结果
    * @Param:  * @param orderPaymentResultDto
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/24 18:42
    */
    void  updateOrderPayemntResult(OrderPaymentResultDto orderPaymentResultDto);



    /**
    * 根据订单商品ID获取详情
    * @Param:  * @param orderGoodsId
    * @return: com.ekingwin.bas.cloud.entity.IpcOrderAllgoods
    * @Author: zhangjie
    * @Date: 2019/10/30 18:46
    */
    IpcOrderAllgoods getOrderGoods(String orderGoodsId);

    IpOrderVo getOrderDetaiil(Long orderId) throws Exception;

    void  deductionGoodsStock(String goodsId,String goodsType,String goodsAmount,String type,String attrId) throws Exception;


    /**
     * 根据流程实例号获取订单详情
     * @param instid
     * @return
     */
    IpcOrder getOrderDetailByInstid(String instid);
}
