package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpcOrderMapper;
import com.ekingwin.bas.cloud.mail.dto.MailInfoDto;
import com.ekingwin.bas.cloud.mail.service.IMailService;
import com.ekingwin.bas.cloud.service.ImailService;
import com.ekingwin.bas.cloud.vo.IpOrderGoodsDetailVo;
import com.ekingwin.bas.cloud.vo.IsendDeliverMailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author 许世文
 * @Date 2019/8/2 17:57
 * @Version 1.0
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class ImailServieImpl implements ImailService {

    @Autowired
    private IpcOrderMapper ipcOrderMapper;

    @Autowired
    @Qualifier(value = "mailServiceImpl")
    private IMailService mailService;

    @Value("${springMailFrom}")
    private String springMailFrom;
    @Value("${springMailFromPass}")
    private String springMailFromPass;
    @Value("${deliverBaseUrl}")
    private String deliverBaseUrl;

    /**
     * 发送发货邮件
     * @param orderNum
     * @throws Exception
     */
    @Override
    public void sendDeliverMail(String orderNum) throws Exception {
        IsendDeliverMailVo mailVo = ipcOrderMapper.getOrderGoodsInfoByOrderNum(orderNum);
        HashMap codeParam = new HashMap();
        MailInfoDto mail = new MailInfoDto();
        Set<String> mailSet = new HashSet<>();
        List<IpOrderGoodsDetailVo> goodsDetailVos = mailVo.getGoodsDetailVos();
        //收件人
        for (IpOrderGoodsDetailVo item :goodsDetailVos){
            if(!item.getEmail().equals("")){
                mailSet.add(item.getEmail());
            }
        }
        List<IpOrderGoodsDetailVo> mailVoList = mailVo.getGoodsDetailVos();
        for (String receiver : mailSet){
            List<IpOrderGoodsDetailVo> receiverGoodsList =  mailVoList.stream().filter(item -> receiver.equals(item.getEmail())).collect(Collectors.toList());
            List<String> receivers = new ArrayList<>();
            receivers.add(receiver);
            codeParam.put("deliverBaseUrl",deliverBaseUrl);
            codeParam.put("projectName",mailVo.getProjectName());
            codeParam.put("stagesName",mailVo.getStagesName());
            codeParam.put("projectLeader",mailVo.getProjectLeader());
            codeParam.put("inputdate",mailVo.getInputdate());
            codeParam.put("goodsDetailVos",receiverGoodsList);
            mail.setParams(codeParam);
            mail.setReceivers(receivers);
            mail.setSubject("融果果发货通知");
            mail.setSender(springMailFrom);
            mail.setSenderPass(springMailFromPass);
            mail.setTemplate("orderInfoTemplate.ftl");
            mailService.sendMailWithTemplate(mail);
        }
    }
}
