package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dto.IpAgreementProcessDto;
import com.ekingwin.bas.cloud.process.dto.CreateProcessDto;
import com.ekingwin.bas.cloud.process.service.IpcProcessService;
import com.ekingwin.bas.cloud.service.IpAgreementProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 协议确认
 * @ClassName: IpAgreementProcessService
 * @Author: liujunfeng
 * @Date: 2019/12/4 17:46
 * @description:
 */
@Service
@Primary
public class IpAgreementProcessServiceImpl implements IpAgreementProcessService{



    @Autowired
    private IpcProcessService ipcProcessService;


    /**
     * 协议确认流程发起
     * @param processDto
     * @throws Exception
     */
    @Override
    public void startAgreement(IpAgreementProcessDto processDto)throws Exception {
        //保存成功之后调用发起流程的接口
        CreateProcessDto createProcessDto = new CreateProcessDto();
        createProcessDto.setUserId(processDto.getApplicationnumber());
        createProcessDto.setProcessName("AgreementProcess");
        Map<String,Object> map = new HashMap<>();
        map.put("GYSQR",processDto.getSuppliercode());
        createProcessDto.setBusinessData(map);
        createProcessDto.setSubject(processDto.getTheme());
        createProcessDto.setBusinessId(processDto.getContractnamecode());
        ipcProcessService.createProcess(createProcessDto);

    }
}
