package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpCustAddressMapper;
import com.ekingwin.bas.cloud.dto.IpCustAddressDto;
import com.ekingwin.bas.cloud.dto.IpOrderAddressDto;
import com.ekingwin.bas.cloud.entity.IpCustAddress;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.service.IpCustAddressService;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * ；零售客户地址信息
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-25 13:40
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpCustAddressServiceImpl extends BaseService implements IpCustAddressService {

    @Autowired
    private IpCustAddressMapper ipCustAddressMapper;



    /**
    * 保存与修改客户地址
    * @Param:  * @param ipCustAddressDto
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/25 13:52
    */
    @Override
    public void  saveCustAdderss(IpCustAddressDto ipCustAddressDto) throws Exception{
        IpCustAddress ipCustAddress = new IpCustAddress();
        this.commonBuild(ipCustAddress, ipCustAddressDto);
        ipCustAddress.setUserId(ipCustAddressDto.getUserid());
        ipCustAddress.setIsDelete("N");
        String isDefault = ipCustAddressDto.getIsDefault();
        String userId=ipCustAddressDto.getUserid();
        //判断地址是否默认
        if (StringUtils.isNotEmpty(isDefault)&& "Y".equals(isDefault)){
            ipCustAddressMapper.updateAddressDefault("N",userId);
        }
        if (ipCustAddressDto.getId()!=null){
            ipCustAddressMapper.updateCustAddress(ipCustAddress);
        }else {
            ipCustAddressMapper.insertSelective(ipCustAddress);
        }
    }
    /**
    * 删除地址
    * @Param:  * @param id
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 14:38
    */
    @Override
    public int deleteCustAddress(Long id){

        return ipCustAddressMapper.updateAddressDelete(id);
    }

    /**
    * 设置默认地址
    * @Param:  * @param id
     * @param userId
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 15:10
    */
    @Override
    public int defaultCustAddress(Long id,String userId){
        ipCustAddressMapper.updateAddressDefault("N", userId);
        return  ipCustAddressMapper.updateAddressDefaultById(id);
    }


    @Override
    public PageInfo<IpCustOrderAddressVo> getCustAddress(IpOrderAddressDto orderAddressDto){
        PageHelper.startPage(orderAddressDto.getPagenum(),orderAddressDto.getPagesize());
        List<IpCustOrderAddressVo> addressByUserId = ipCustAddressMapper.getCustAddressList(orderAddressDto);
        PageInfo<IpCustOrderAddressVo> pageInfo = new PageInfo<>(addressByUserId);
        return pageInfo;
    }



    /**
    * 获取默认地址
    * @Param:  * @param userId
    * @return: com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo
    * @Author: zhangjie
    * @Date: 2019/10/25 16:24
    */
    @Override
    public IpCustOrderAddressVo getCustAddress(String userId){
        IpOrderAddressDto orderAddressDto=new IpOrderAddressDto();
        orderAddressDto.setIsDefault("Y");
        orderAddressDto.setUserid(userId);
        List<IpCustOrderAddressVo> addressByUserId = ipCustAddressMapper.getCustAddressList(orderAddressDto);
        IpCustOrderAddressVo orderAddress=null;
        if (addressByUserId !=null && addressByUserId.size()>0){
            orderAddress=addressByUserId.get(0);
        }
        return orderAddress;

    }

}
