package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpGoodContractMapper;
import com.ekingwin.bas.cloud.dto.IpContractGoodDto;
import com.ekingwin.bas.cloud.dto.IpGoodsContractDto;
import com.ekingwin.bas.cloud.service.IpGoodsContractService;
import com.ekingwin.bas.cloud.vo.IpContractGoodsVo;
import com.ekingwin.bas.cloud.vo.IpGoodsContractVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-30 12:04
 **/
@Service
@Primary
public class IpGoodsContractServiceImpl implements IpGoodsContractService {

    @Autowired
    private IpGoodContractMapper ipGoodContractMapper;

    /**
     * 根据项目编号和商品编码获取商品合同
     * @param ipGoodsContractDto
     * @return
     */
    @Override
    public PageInfo selectGoodContract(IpGoodsContractDto ipGoodsContractDto){

        PageHelper.startPage(ipGoodsContractDto.getPagenum(),ipGoodsContractDto.getPagesize());
        List<IpGoodsContractVo> ipGoodsContractVoList =ipGoodContractMapper.selectGoodContract(ipGoodsContractDto);
        PageInfo pageInfo = new PageInfo<>(ipGoodsContractVoList);
        return pageInfo;
    }

    /**
     *
     * @param ipContractGoodDto
     * @return
     */
    @Override
    public List<IpContractGoodsVo> getContractGoodsVo(IpContractGoodDto ipContractGoodDto){

       return ipGoodContractMapper.getContractGoods(ipContractGoodDto);
    }

    /**
     * 扣减合同的商品数量
     * @return
     */
    @Override
    public int updateContractGoods(IpContractGoodDto ipContractGoodDto){
        return  ipGoodContractMapper.updateContractGoodsNum(ipContractGoodDto);
    }

}
