package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpGroupBuyingManagerMapper;
import com.ekingwin.bas.cloud.dao.ProcessInstanceMapper;
import com.ekingwin.bas.cloud.dto.IpGroupBuyingDetailDto;
import com.ekingwin.bas.cloud.dto.IpGroupBuyingManagerDto;
import com.ekingwin.bas.cloud.entity.ProcessInstance;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.service.IpGroupBuyingManagerService;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpGroupBuyingListVo;
import com.ekingwin.bas.cloud.vo.IpGroupBuyingSearchDataVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author yuzm
 * @date 2019/10/12 10:33
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpGroupBuyingManagerServiceImpl extends BaseService implements IpGroupBuyingManagerService {

    @Autowired
    private IpGroupBuyingManagerMapper ipGroupBuyingManagerMapper;

    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    /**
     * 查询协议列表
     * @param ipGroupBuyingManagerDto
     * @return
     */
    @Override
    public PageInfo selectGroupBuyingList(IpGroupBuyingManagerDto ipGroupBuyingManagerDto) {
        PageHelper.startPage(ipGroupBuyingManagerDto.getPagenum(),ipGroupBuyingManagerDto.getPagesize());
        List<IpGroupBuyingListVo> ipGroupBuyingListVos;
        if (StringUtils.isNotEmpty(ipGroupBuyingManagerDto.getSupplierid())) {
            ipGroupBuyingListVos = ipGroupBuyingManagerMapper.selectBySuppliers(ipGroupBuyingManagerDto);
        } else {
            ipGroupBuyingListVos = ipGroupBuyingManagerMapper.selectByNoSuppliers(ipGroupBuyingManagerDto);
        }
        return new PageInfo<>(ipGroupBuyingListVos);
    }

    /**
     * 查询协议详情
     * @param ipGroupBuyingDetailDto
     * @return
     */
    @Override
    public IpGroupBuyingSearchDataVo selectGroupBuyingDetail(IpGroupBuyingDetailDto ipGroupBuyingDetailDto) {
        IpGroupBuyingSearchDataVo ipGroupBuyingSearchDataVo = null;
        String contractId  =null;
        String instid = ipGroupBuyingDetailDto.getInstid();
        if (StringUtils.isNotEmpty(instid)){
            ProcessInstance processInstance = processInstanceMapper.selectByInstanceId(instid);
            contractId=processInstance.getBusinessid();
        }else {
            contractId= ipGroupBuyingDetailDto.getContractId();
        }
        if (contractId != null) {
            ipGroupBuyingSearchDataVo = ipGroupBuyingManagerMapper.selectGroupBuying(contractId);
            if (ipGroupBuyingSearchDataVo != null) {
                ipGroupBuyingSearchDataVo.setContRangeInfos(ipGroupBuyingManagerMapper.selectContRangeInfo(contractId));
                ipGroupBuyingSearchDataVo.setContAttachInfos(ipGroupBuyingManagerMapper.selectContAttachInfo(contractId));
            }
        }
        return ipGroupBuyingSearchDataVo;
    }
}
