package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.InvoiceMapper;
import com.ekingwin.bas.cloud.dto.IpInvoiceEntityPageDto;
import com.ekingwin.bas.cloud.entity.IpInvoiceEntity;
import com.ekingwin.bas.cloud.service.IpInvoiceEntityService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 发票
 * @ClassName: IpInvoiceEntityServiceImpl
 * @Author: liujunfeng
 * @Date: 2019/12/9 22:28
 * @description:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpInvoiceEntityServiceImpl implements IpInvoiceEntityService {

    @Autowired
    InvoiceMapper invoiceMapper;


    /**
     * 查询开票列表
     * @param entityPageDto
     * @return
     */
    @Override
    public PageInfo<IpInvoiceEntity> getInvoiceLsit(IpInvoiceEntityPageDto entityPageDto) {
        PageHelper.startPage(entityPageDto.getPagenum(), entityPageDto.getPagesize());
        List<IpInvoiceEntity> invoiceList = invoiceMapper.selectInvoiceList(entityPageDto);
        return new PageInfo<>(invoiceList);
    }
}
