package com.ekingwin.bas.cloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.ekingwin.bas.cloud.config.SapPathConfig;
import com.ekingwin.bas.cloud.dao.IpInvoiceDetailMapper;
import com.ekingwin.bas.cloud.dao.IpInvoiceGoodsMapper;
import com.ekingwin.bas.cloud.dao.IpInvoiceMapper;
import com.ekingwin.bas.cloud.dao.IpOrderReconciliationSummaryMapper;
import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.dto.sapmessage.SapInvoiceReturnDto;
import com.ekingwin.bas.cloud.entity.*;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.rabbit.sender.SapInvoiceSender;
import com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode;
import com.ekingwin.bas.cloud.service.IpInvoiceService;
import com.ekingwin.bas.cloud.service.IpProjectContractManagerService;
import com.ekingwin.bas.cloud.util.ExportExcelUtil;
import com.ekingwin.bas.cloud.util.HttpXmlClient;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.*;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode.YEARMONTHDAY;

/**
 * @ClassName: IpInvoiceServiceImpl
 * @Author: liujunfeng
 * @Date: 2019/11/21 17:19
 * @description:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpInvoiceServiceImpl extends BaseService implements IpInvoiceService {

    @Autowired
    private SapPathConfig sapPathConfig;

    @Autowired
    IpInvoiceMapper invoiceMapper;

    @Autowired
    IpInvoiceDetailMapper invoiceDetailMapper;

    @Autowired
    IpInvoiceGoodsMapper invoiceGoodsMapper;

    @Autowired
    SapInvoiceSender sapInvoiceSender;

    @Autowired
    IpProjectContractManagerService projectContractManagerService;

    @Autowired
    IpOrderReconciliationSummaryMapper orderReconciliationSummaryMapper;


    @Override
    public PageInfo<IpInvoiceLsitVo> getInvoiceLsit(IpInvoicePageDto invoicePageDto) {
        PageHelper.startPage(invoicePageDto.getPagenum(), invoicePageDto.getPagesize());
        List<IpInvoiceLsitVo> invoiceLsitVoList = invoiceMapper.selectInvoiceList(invoicePageDto);
        return new PageInfo<>(invoiceLsitVoList);
    }

    @Override
    public IpInvoiceDto getInvoice(IpInvoicePageDto invoicePageDto) {
        IpInvoiceDto invoiceDto = invoiceMapper.getInvoice(invoicePageDto.getId());
        String attachment = invoiceDto.getAttachment();
        List<String> ids = new ArrayList<String>();
        if (StringUtils.isNotEmpty(attachment)) {
            String[] str = attachment.split(",");
            if (str.length > 0) {
                for (String st : str) {
                    ids.add(st);
                }
            }
        }
        if (ids.size() > 0) {
            List<Documentation> list = invoiceMapper.getFiles(ids);
            invoiceDto.setFiles(list);
        }
        if ("N".equals(invoicePageDto.getConditions())) {
            List<IpInvoiceGoodsDto> invoiceGoodsDtoList = invoiceGoodsMapper.selectInvoiceGoodsDto(invoicePageDto.getId());
            invoiceDto.setInvoiceGoods(invoiceGoodsDtoList);
        }
        return invoiceDto;
    }

    @Override
    public String saveInvoice(IpInvoiceDto invoiceDto) throws Exception {
        Long id = invoiceDto.getId();
        String results = "";
        if (id == null) {
            IpInvoice ipInvoice = new IpInvoice();
            this.commonBuild(ipInvoice, invoiceDto);
            ipInvoice.setApplyForDate(new Date());
            ipInvoice.setApplicantCode(invoiceDto.getUserid());
            ipInvoice.setApplicantName(invoiceDto.getUserName());
            //生成付款单号
            String invoiceNum = invoiceDto.getApplyForNum();
            //判断是否存在申请单号，不存在则生成单号
            if (StringUtils.isEmpty(invoiceNum)) {
                invoiceNum = GenerateRequestCode.requestCode("invoiceNum", YEARMONTHDAY, 4, "FPJL");
            }
            ipInvoice.setApplyForNum(invoiceNum);
            invoiceDto.setApplyForNum(invoiceNum);
            invoiceMapper.saveIpInvoice(ipInvoice);
            Long buskey = ipInvoice.getId();
            this.saveInvoiceDetail(invoiceDto, buskey);
            this.saveInvoiceGoods(invoiceDto, buskey);
            //同步发票记录到SAP
            results = this.initInvoiceRecord(invoiceDto, "C");
        } else {
            IpInvoice ipInvoice = new IpInvoice();
            this.commonBuild(ipInvoice, invoiceDto);
            ipInvoice.setUpdateDate(new Date());
            invoiceMapper.updateIpInvoice(ipInvoice);
            invoiceDetailMapper.deleteDetail(id);
            this.saveInvoiceDetail(invoiceDto, id);
            invoiceGoodsMapper.deleteGoods(id);
            this.saveInvoiceGoods(invoiceDto, id);
            //同步发票记录到SAP
            results = this.initInvoiceRecord(invoiceDto, "U");
        }
        return results;
    }


    @Override
    public List<IpPaymentApplyVo> getRetailPurchasesList(IpPurchasesDto purchasesDto) throws Exception {
        List<IpPaymentApplyVo> applyVos = invoiceMapper.getRetailPurchasesList(purchasesDto);
        return applyVos;
    }

    @Override
    public IpPaymentApplyVo getEngineeringPurchasesList(IpPurchasesDto purchasesDto) throws Exception {
        IpPaymentApplyVo paymentApplyVo = invoiceMapper.getEngineeringPurchasesList(purchasesDto);
        if (paymentApplyVo != null) {
            List<IpInvoiceDetailVo> invoiceDetailVos = invoiceMapper.selectEngineeringDetail(purchasesDto);
            paymentApplyVo.setInvoiceDetailVos(invoiceDetailVos);
        }
        return paymentApplyVo;
    }

    private String initInvoiceRecord(IpInvoiceDto invoiceDto, String operation) throws Exception {
        IpSapInvoiceVo recordDto = new IpSapInvoiceVo();
        IpProjectContractSearchDetailVo detailVo = projectContractManagerService.selectProjectContract(invoiceDto.getGoodsContractId());
        if (detailVo != null) {
            recordDto.setCompanyCode(detailVo.getPartyA());
            recordDto.setCompanyName(detailVo.getPartyAName());
            recordDto.setStageName(detailVo.getStageName());
            recordDto.setStageCode(detailVo.getStageNo());
            recordDto.setContractName(detailVo.getContName());
        }
        recordDto.setBillNum(invoiceDto.getApplyForNum());
        recordDto.setBillType("AP");
        recordDto.setSupplierCode(invoiceDto.getUserid());
        recordDto.setSupplierName(invoiceDto.getUserName());
        recordDto.setProjectCode(invoiceDto.getProjectId());
        recordDto.setProjectName(invoiceDto.getProjectName());
        recordDto.setContractCode(invoiceDto.getGoodsContractId());
        recordDto.setContractPrice(invoiceDto.getTotalPrice());
        recordDto.setInvoiceType(invoiceDto.getInvoiceType());
        recordDto.setTaxPrice(invoiceDto.getTotalInvoicePrice());
        recordDto.setTaxAmount(invoiceDto.getTotalTaxAmount());
        recordDto.setRemark(invoiceDto.getRemarks());
        recordDto.setSystemSource("2");
        recordDto.setDstype(invoiceDto.getPaymentType());
        recordDto.setAccStatement(invoiceDto.getReconciliationNum());
        recordDto.setOperation(operation);
        recordDto.setEXTEND2("");

        List<IpInvoiceDetailDto> invoiceList = invoiceDto.getInvoiceDetail();
        List<IpSapInvoiceDetailVo> detailList = null;
        if (invoiceList != null && invoiceList.size() > 0) {
            detailList = new ArrayList<>();
            IpSapInvoiceDetailVo detail;
            for (IpInvoiceDetailDto detailDto : invoiceList) {
                detail = new IpSapInvoiceDetailVo();
                detail.setInvoiceType(invoiceDto.getInvoiceType());
                detail.setInvoiceNo(detailDto.getInvoiceNo());
                detail.setInvoiceCode(detailDto.getInvoiceCode());
                detail.setAmountWithTax(detailDto.getTaxAmount());
                BigDecimal amount = detailDto.getTaxAmount().subtract(detailDto.getTaxAmountNo());
                detail.setTaxAmount(amount);
                detail.setExtend1("");
                detail.setExtend2("");
                detailList.add(detail);
            }
        }
        recordDto.setInvoice(detailList);

        List<IpInvoiceGoodsDto> goodsDtoList = invoiceDto.getInvoiceGoods();
        List<IpSapInvoiceItemVo> itemDtoList = null;
        if (goodsDtoList != null && goodsDtoList.size() > 0) {
            itemDtoList = new ArrayList<>();
            IpSapInvoiceItemVo item;
            for (int x = 0; x < goodsDtoList.size(); x++) {
                IpInvoiceGoodsDto goodsDto = goodsDtoList.get(x);
                item = new IpSapInvoiceItemVo();
                IpOrderReconciliationRecord record = invoiceGoodsMapper.selectReconciliationRecord(goodsDto.getGoodsCode(),invoiceDto.getContractCode());
                if (record != null) {
                    item.setVendorType(record.getFtnpthreecategorycode());
                    item.setPrice(record.getPriceSupplier());
                    item.setSalePrice(record.getPrice());
                }
                item.setBuzei(String.valueOf(x + 1));
                item.setGoodsCode(goodsDto.getGoodsCode());
                item.setGoodsName(goodsDto.getGoodsName());
                item.setSpecification(goodsDto.getBillSpecModel());
                item.setWaers("CNY");
                item.setUnit(goodsDto.getUnit());
                item.setQuant(StringUtils.stringToBigDecimal(goodsDto.getInvoiceNo()));
                item.setYfQuant(StringUtils.stringToBigDecimal(goodsDto.getReceivedBillNo()));
                item.setTotalQuant(StringUtils.stringToBigDecimal(goodsDto.getReceivedGoodsNo()));
                item.setTaxRate(StringUtils.stringToBigDecimal(goodsDto.getRate()));

                BigDecimal shouhuoshuliang = StringUtils.stringToBigDecimal(goodsDto.getInvoiceNo());
                item.setTaxAmt(goodsDto.getRateGoods().multiply(shouhuoshuliang));
                item.setAmtIncltax(goodsDto.getTaxAmountGoods().multiply(shouhuoshuliang));
                item.setAmtExcltax(goodsDto.getNoTaxAmountGoods().multiply(shouhuoshuliang));

                item.setBillGoodsName(goodsDto.getBillGoodsName());
                item.setBillTypeCode(goodsDto.getBillSpecModel());
                item.setTaxTypeCode(goodsDto.getTaxTypeCode());
                item.setProtocoId("");

                item.setExtend1("");
                item.setExtend2("");
                itemDtoList.add(item);
            }
        }
        recordDto.setItem(itemDtoList);
        IpSapInvoiceHeadVo headVo = new IpSapInvoiceHeadVo();
        headVo.setHead(recordDto);


        String string = JSONArray.fromObject(headVo).toString();
        //RESTful处理
        String invoiceResult = HttpXmlClient.post1(string, sapPathConfig.getInvoicepath());
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(invoiceResult);
        String code = jsonObject.get("code").toString();
        if ("500".equals(code)) {
            String msg = jsonObject.get("msg").toString();
            throw new BusinessException(500, msg);
        }
        IpInvoiceRealReturnDto ipInvoiceReturn = JSON.toJavaObject((JSON) jsonObject.get("data"),IpInvoiceRealReturnDto.class);
        SapInvoiceReturnDto invoiceReturnDto = new SapInvoiceReturnDto();
        invoiceReturnDto.setPaymentnum(ipInvoiceReturn.getDsdjh());
        invoiceReturnDto.setStatus(ipInvoiceReturn.getWebdjzt());
        invoiceMapper.updateInvoice(invoiceReturnDto);
        //消息队列处理
//        sapInvoiceSender.send("order.sapinvoice.info",string);

        return null;
    }

    @Override
    public void sapInvoiceReturn(SapInvoiceReturnDto invoiceReturnDto) {
        invoiceMapper.updateInvoice(invoiceReturnDto);
        if ("95".equals(invoiceReturnDto.getStatus())) {
            IpInvoiceDto invoiceDto = invoiceMapper.selectInvoiceId(invoiceReturnDto.getPaymentnum());
            this.dealWith(invoiceDto);
        }
    }

    private void dealWith(IpInvoiceDto invoiceDto) {
        List<IpInvoiceGoods> goodsList = invoiceGoodsMapper.selectInvoiceGoods(invoiceDto.getId());
        if (goodsList != null && goodsList.size() > 0) {
            for (IpInvoiceGoods goods : goodsList) {
                IpOrderReconciliationSummary summary = orderReconciliationSummaryMapper.selectReconciliationGoodsCode(goods.getGoodsCode(),invoiceDto.getContractCode());
                BigDecimal becishuliang = StringUtils.stringToBigDecimal(goods.getInvoiceNo());
                BigDecimal beciprice = invoiceDto.getTotalInvoicePrice();

                BigDecimal lishishuliang = StringUtils.stringToBigDecimal(summary.getInvoicenum());
                BigDecimal lishiprice = summary.getInvoiceprice();
                BigDecimal invoicenum = lishishuliang.subtract(becishuliang);
                BigDecimal invoiceprice = lishiprice.subtract(beciprice);
                summary.setInvoicenum(String.valueOf(invoicenum));
                summary.setInvoiceprice(invoiceprice);
                if ("1".equals(summary.getIsInvoice())) {
                    summary.setIsInvoice("0");
                }
                orderReconciliationSummaryMapper.updateReconciliationSummary(summary);
            }
        }
    }


    private void saveInvoiceDetail(IpInvoiceDto invoiceDto, Long id) throws Exception {
        List<IpInvoiceDetailDto> detailDtoList = invoiceDto.getInvoiceDetail();
        if (detailDtoList != null && detailDtoList.size() > 0) {
            IpInvoiceDetail invoiceDetail;
            for (IpInvoiceDetailDto detailDto : detailDtoList) {
                invoiceDetail = new IpInvoiceDetail();
                this.commonBuild(invoiceDetail, detailDto);
                invoiceDetail.setId(null);
                invoiceDetail.setInvoiceId(id);
                invoiceDetailMapper.saveInvoiceDetail(invoiceDetail);
            }
        }
    }

    private void saveInvoiceGoods(IpInvoiceDto invoiceDto, Long id) throws Exception {
        List<IpInvoiceGoodsDto> goodsDtoList = invoiceDto.getInvoiceGoods();
        if (goodsDtoList != null && goodsDtoList.size() > 0) {
            IpInvoiceGoods invoiceGoods;
            for (IpInvoiceGoodsDto goodsDto : goodsDtoList) {
                Long summaryId = this.saveOrUpdateSummary(goodsDto,invoiceDto);

                invoiceGoods = new IpInvoiceGoods();
                this.commonBuild(invoiceGoods, goodsDto);
                invoiceGoods.setId(null);
                invoiceGoods.setInvoiceId(id);
                invoiceGoods.setSorting(summaryId.intValue());
                invoiceGoodsMapper.saveInvoiceGoods(invoiceGoods);

            }
        }
    }

    @Override
    public void getExcel(HttpServletResponse response, IpInvoicePageDto ipInvoicePageDto) throws Exception {
        ExportExcelUtil<IpInvoiceLsitExcelVo> util = new ExportExcelUtil<>();
        List<IpInvoiceLsitExcelVo> excel = invoiceMapper.getExcel(ipInvoicePageDto);
        String fileName = String.valueOf(System.currentTimeMillis()).substring(4, 13) + ".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr = "attachment; filename=\"" + encode + "\"";
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition", headStr);
        ServletOutputStream outputStream = response.getOutputStream();
        String[] invoiceCloumn = {
                "发票号","合同编码","合同名称","发票合计金额","创建时间","状态"
        };
        util.exportExcel("发票文件", invoiceCloumn, excel, outputStream, ExportExcelUtil.EXCEl_FILE_2007);
        outputStream.flush();
        outputStream.close();
    }


    private Long saveOrUpdateSummary(IpInvoiceGoodsDto goodsDto,IpInvoiceDto invoiceDto){
        Long summaryId = null;
        BigDecimal yiKaiPiaoShuLiang = StringUtils.stringToBigDecimal(goodsDto.getReceivedBillNo());
        BigDecimal benCiKaiPiaoShuLiang = StringUtils.stringToBigDecimal(goodsDto.getInvoiceNo());
        BigDecimal benCiKaiPiaoprice = invoiceDto.getTotalInvoicePrice();
        BigDecimal yishouhushuliang = StringUtils.stringToBigDecimal(goodsDto.getReceivedGoodsNo());
        BigDecimal receivedBillNo = yiKaiPiaoShuLiang.add(benCiKaiPiaoShuLiang);
        IpOrderReconciliationSummary summary = orderReconciliationSummaryMapper.selectReconciliationGoodsCode(goodsDto.getGoodsCode(),invoiceDto.getContractCode());
        if (summary != null){
            BigDecimal lishishuliang = StringUtils.stringToBigDecimal(summary.getInvoicenum());
            BigDecimal lishiprice = summary.getInvoiceprice();
            BigDecimal invoicenum = lishishuliang.add(benCiKaiPiaoShuLiang);
            BigDecimal invoiceprice = lishiprice.add(benCiKaiPiaoprice);
            summary.setInvoicenum(String.valueOf(invoicenum));
            summary.setInvoiceprice(invoiceprice);
            //发起发票记录后修改订单对账状态
            if (yishouhushuliang != null && receivedBillNo != null) {
                if (yishouhushuliang.compareTo(receivedBillNo) == 0) {
                    summary.setIsInvoice("1");
                }
            }
            summaryId = summary.getId();
            orderReconciliationSummaryMapper.updateReconciliationSummary(summary);
        }else {
            IpOrderReconciliationSummary summarys = new IpOrderReconciliationSummary();
            summarys.setGoodsnum(goodsDto.getGoodsCode());
            summarys.setContractCode(invoiceDto.getContractCode());
            summarys.setShipperId(invoiceDto.getApplicantCode());
            summarys.setOrderType("XM");
            summarys.setInputDate(new Date());
            summarys.setGoodsName(goodsDto.getGoodsName());
            summarys.setContractName(invoiceDto.getContractName());
            summarys.setRate(goodsDto.getRate());
            summarys.setBillGoodsName(goodsDto.getBillGoodsName());
            summarys.setBillSpecifiModel(goodsDto.getBillSpecModel());
            summarys.setTaxTypeCode(goodsDto.getTaxTypeCode());
            summarys.setNotaxPriceSupplier(goodsDto.getNoTaxAmountGoods());
            summarys.setPriceSupplier(goodsDto.getTaxAmountGoods());
            summarys.setInvoicenum(goodsDto.getInvoiceNo());
            summarys.setInvoiceprice(invoiceDto.getTotalInvoicePrice());
            summarys.setShipperId(invoiceDto.getApplicantCode());
            summaryId = orderReconciliationSummaryMapper.saveReconciliationSummary(summarys);
        }
        return summaryId;
    }


}
