package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpNoticeMapper;
import com.ekingwin.bas.cloud.dto.IpNoticeDto;
import com.ekingwin.bas.cloud.dto.IpNoticePageDto;
import com.ekingwin.bas.cloud.entity.IpNotice;
import com.ekingwin.bas.cloud.service.IpNoticeService;
import com.ekingwin.bas.cloud.util.MapObjUtil;
import com.ekingwin.bas.cloud.vo.IpNoticeVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: huangyl
 * @create: 2019-07-11 15:24
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpNoticeServiceImpl implements IpNoticeService {


    @Value("${goods.baseurl}")
    private String basPath;
    @Autowired
   private IpNoticeMapper ipNoticeMapper;

    @Override
    public PageInfo getNoticeList(IpNoticePageDto ipNoticePageDto) {
        String subject = ipNoticePageDto.getSearchData();
        String supplierid = ipNoticePageDto.getSupplierid();

        PageHelper.startPage(ipNoticePageDto.getPagenum(), ipNoticePageDto.getPagesize());
        List<IpNoticeVo> ipNoticeDtoList = ipNoticeMapper.selectNoticeList(ipNoticePageDto);
 /*       List<IpNoticeVo> ipNoticeDtoList1=ipNoticeMapper.selectNoticeListByJurisdiction();
        if(ipNoticeDtoList1.size()>0){
            for (int i = 0; i < ipNoticeDtoList1.size(); i++) {
                ipNoticeDtoList.add(ipNoticeDtoList1.get(i));
            }
        }*/
        PageInfo page =new PageInfo<>(ipNoticeDtoList);
        return page;
    }

    @Override
    public IpNoticeVo getNoticeById(Long id) throws  Exception{
        IpNotice ipNotice =ipNoticeMapper.selectByPrimaryKey(id);
        IpNoticeVo ipNoticeVo = new IpNoticeVo();
        MapObjUtil.copy(ipNotice,ipNoticeVo);
        return ipNoticeVo;
    }

    @Override
    public boolean updateNotice(IpNoticeDto ipNoticeDto) throws  Exception{
        IpNotice ipNotice = new IpNotice();
        MapObjUtil.copy(ipNoticeDto,ipNotice);
        int id=ipNoticeMapper.updateByPrimaryKey(ipNotice);
        if(id >0){
            return  true;
        }else{
            return false;
        }
    }

    @Override
    public boolean addNotice(IpNoticeDto ipNoticeDto) throws Exception {
        IpNotice ipNotice = new IpNotice();
        ipNoticeDto.setPublishertime(new Date());
        MapObjUtil.copy(ipNoticeDto,ipNotice);
        int id =ipNoticeMapper.insert(ipNotice);
        if(id >0){
            return  true;
        }else{
            return false;
        }
    }

    @Override
    public boolean delNotice(Long id) throws Exception {
        int result =ipNoticeMapper.deleteByPrimaryKey(id);
        if(result >0){
            return true;
        }
        return false;
    }
}
