package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpOrderDeliverGoodMapper;
import com.ekingwin.bas.cloud.dao.IpOrderDeliverLogisticsMapper;
import com.ekingwin.bas.cloud.dao.IpOrderDeliverMapper;
import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.entity.IpOrderDeliver;
import com.ekingwin.bas.cloud.entity.IpOrderDeliverGood;
import com.ekingwin.bas.cloud.entity.IpOrderDeliverLogistics;
import com.ekingwin.bas.cloud.entity.IpcOrderAllgoods;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.rabbit.sender.LogicSender;
import com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode;
import com.ekingwin.bas.cloud.service.IpOrderDeliverService;
import com.ekingwin.bas.cloud.service.IpcOrderService;
import com.ekingwin.bas.cloud.util.MapObjUtil;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpDeliverLogisticsVo;
import com.ekingwin.bas.cloud.vo.IpOrderDeliverGoodVo;
import com.ekingwin.bas.cloud.vo.IpOrderDeliverVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;


/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-05 10:06
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpOrderDeliverServiceImpl implements IpOrderDeliverService {


    @Autowired
    private IpOrderDeliverMapper ipOrderDeliverMapper;

    @Autowired
    private IpOrderDeliverGoodMapper ipOrderDeliverGoodMapper;

    @Autowired
    private IpcOrderService ipcOrderService;

    @Autowired
    private IpOrderDeliverLogisticsMapper ipOrderDeliverLogisticsMapper;


    @Value("${goods.baseurl}")
    private String basPath;

    @Autowired
    private LogicSender logicSender;



    /**
     * 保存单据信息
     *
     * @param ipOrderDeliverDto
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public Long saveOrUpdateDeliver(IpOrderDeliverDto ipOrderDeliverDto) throws Exception {
        Long id = this.saveOrUpdate(ipOrderDeliverDto);

        /**
         * 保存字单数据
         */
        this.updateDeliverGoods(ipOrderDeliverDto, id);
        return id;
    }

    /**
     * 保存主单据
     *
     * @param ipOrderDeliverDto
     * @return
     * @throws Exception
     */
    private Long saveOrUpdate(IpOrderDeliverDto ipOrderDeliverDto) throws Exception {
        Long id = ipOrderDeliverDto.getId();
        //送货单号
        String deliverNum = ipOrderDeliverDto.getDeliverNum();
        //判断单号是否为空，若为空生成单号
        if (StringUtils.isEmpty(deliverNum)) {
            //deliverNum = ipOrderDeliverMapper.getDeliverNum();
            deliverNum= GenerateRequestCode.requestCode("orderDeliver", GenerateRequestCode.YEARMONTHDAY, 4, "SH");
        }
        IpOrderDeliver ipOrderDeliver = new IpOrderDeliver();
        MapObjUtil.copy(ipOrderDeliverDto, ipOrderDeliver);
        //拼接权限的人
        Set<String> users = new HashSet<>();
        users.add(ipOrderDeliverDto.getProjectLeaderCode());
        users.add(ipOrderDeliverDto.getSupervisorCode());
        if (StringUtils.isNotEmpty(ipOrderDeliverDto.getReceiverCodes())) {
            String[] lists = ipOrderDeliverDto.getReceiverCodes().split(",");
            for (String list : lists) {
                users.add(list);
            }
        }
        ipOrderDeliver.setStatus("待收货");
        ipOrderDeliver.setDeliverNum(deliverNum);
        if (users !=null && users.size()>0){
            ipOrderDeliver.setReceiverCodeNum(String.join(",", users));
        }
        //判断修改还是新增
        if (id != null && id != 0) {
            ipOrderDeliver.setUpdateTime(new Date());
            ipOrderDeliverMapper.updateByPrimaryKeySelective(ipOrderDeliver);
        } else {
            ipOrderDeliver.setCreateId(ipOrderDeliverDto.getUserid());
            ipOrderDeliver.setCreateTime(new Date());
            ipOrderDeliverMapper.insertSelective(ipOrderDeliver);
            id = ipOrderDeliver.getId();
        }
        //判断是否选择物流公司，若未选则不推送

        if (StringUtils.isNotEmpty(ipOrderDeliver.getLogisticsCompanyCode())) {
            this.sendLogicMessage(ipOrderDeliver);
        }

        return id;
    }

    /**
     * 推送消息到快递100
     *
     * @Param: * @param ipOrderDeliver
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/24 20:07
     */
    private void sendLogicMessage(IpOrderDeliver ipOrderDeliver) throws Exception {
        SendLogicMessageDto sendLogicMessageDto = new SendLogicMessageDto();
        sendLogicMessageDto.setCompanycode(ipOrderDeliver.getLogisticsCompanyCode());
        sendLogicMessageDto.setCompanyname(ipOrderDeliver.getLogisticsCompanyCode());
        sendLogicMessageDto.setPhone(ipOrderDeliver.getPhone());
        sendLogicMessageDto.setCouriernumber(ipOrderDeliver.getLogisticsNum());
        sendLogicMessageDto.setState("发货");
        sendLogicMessageDto.setSendnumber(ipOrderDeliver.getDeliverNum());
        //
        String jsonStr = JSONObject.fromObject(sendLogicMessageDto).toString();
        logicSender.send("deliver.logic.info", jsonStr);
    }

    /**
     * 保存送货单商品信息
     *
     * @param ipOrderDeliverDto
     */
    private void updateDeliverGoods(IpOrderDeliverDto ipOrderDeliverDto, Long id) throws Exception {
        String orderType=ipOrderDeliverDto.getOrderType();
        /**
         * 删除送货单信息
         */
        ipOrderDeliverGoodMapper.deleteByDeliverId(id);

        List<IpOrderDeliverGoodDto> goods = ipOrderDeliverDto.getGoods();
        if (goods != null && goods.size() > 0) {
            IpOrderDeliverGood ipOrderDeliverGood = null;

            IpOrderGoodsStatusDto ipOrderGoodsStatusDto = null;
            for (IpOrderDeliverGoodDto good : goods) {
                ipOrderDeliverGood = new IpOrderDeliverGood();

                ipOrderGoodsStatusDto = new IpOrderGoodsStatusDto();


                //总商品数量
                BigDecimal totalNum = good.getCount();
                //已发货数量
                BigDecimal yshippedCount = good.getYshippedCount();
                if (yshippedCount==null) {
                    yshippedCount = new BigDecimal("0.00");
                }
                //本次发货数量
                BigDecimal bshippedCount = good.getBshippedCount();
                if (bshippedCount==null) {
                    bshippedCount = new BigDecimal("0.00");
                }
                String orderGoodsId = good.getOrderGoodsId();
                ipOrderGoodsStatusDto.setGoodsDeliver(bshippedCount);
                ipOrderGoodsStatusDto.setOrderGoodsId(orderGoodsId);

                MapObjUtil.copy(good, ipOrderDeliverGood);
                ipOrderDeliverGood.setDeliverId(id);

                IpcOrderAllgoods orderGoods = ipcOrderService.getOrderGoods(orderGoodsId);
                BigDecimal goodsDeliver=null;
                if(orderGoods !=null){
                    goodsDeliver = orderGoods.getGoodsDeliver();
                }
                if (goodsDeliver==null){
                    goodsDeliver=new BigDecimal("0.00");
                }
                //保存发货单商品数据
               // ipOrderDeliverGoodMapper.insertSelective(ipOrderDeliverGood);
                if (StringUtils.isNotEmpty(orderType)&& "GR".equals(orderType)){
              /*      IpcOrderAllgoods orderGoods = ipcOrderService.getOrderGoods(orderGoodsId);
                    BigDecimal goodsDeliver = orderGoods.getGoodsDeliver();*/
                    if (goodsDeliver==null){
                        goodsDeliver=new BigDecimal("0.00");
                    }
                    if (totalNum.compareTo(goodsDeliver.add(bshippedCount))==-1){
                        throw new BusinessException(500, "此商品已发货，请核对商品");
                    }
                    ipOrderDeliverGood.setStatus("待收货");
                }
                ipOrderDeliverGoodMapper.insertSelective(ipOrderDeliverGood);
                //判断商品总数量 是否等于已发货+本次发货数量，若相等则为已发货
                if (totalNum.compareTo(goodsDeliver.add(bshippedCount)) != 1) {
                    ipOrderGoodsStatusDto.setStatus("待收货");
                } else {
                    ipOrderGoodsStatusDto.setStatus("部分发货");
                }

                /**
                 * 扣减发货数量
                 */
                ipcOrderService.updateGoodsStatus(ipOrderGoodsStatusDto);
            }
        }
        if (StringUtils.isEmpty(orderType) || "XM".equals(orderType)){
            //自动生成物流信息
            this.saveLogistic("您的订单已发货", id,
                    ipOrderDeliverDto.getUserid(), ipOrderDeliverDto.getUserName());
        }

    }

    /**
     * 获取送货单列表
     *
     * @param ipOrderDeliverListDto
     * @return
     */
    @Override
    public PageInfo getOrderDeliverList(IpOrderDeliverListDto ipOrderDeliverListDto) {

        PageHelper.startPage(ipOrderDeliverListDto.getPagenum(), ipOrderDeliverListDto.getPagesize());

        //获取发货单信息
        List<IpOrderDeliverVo> orderDeliverVos = null;
        if (StringUtils.isNotEmpty(ipOrderDeliverListDto.getIsSupplier())
                && ipOrderDeliverListDto.getIsSupplier().equals("Y")) {
            orderDeliverVos = ipOrderDeliverMapper.getAllOrderDeliver(ipOrderDeliverListDto);
        } else {
            //判断是否是移动端
            if (StringUtils.isNotEmpty(ipOrderDeliverListDto.getIsMobile())
                    && ipOrderDeliverListDto.getIsMobile().equals("N")) {
                orderDeliverVos = ipOrderDeliverMapper.getAllOrderDeliverNoSupplierNoMobile(ipOrderDeliverListDto);
            } else {
                orderDeliverVos = ipOrderDeliverMapper.getAllOrderDeliverNoSupplier(ipOrderDeliverListDto);
            }

        }

        //根据发货单查询商品信息
        if (orderDeliverVos != null && orderDeliverVos.size() > 0) {
            IpOrderDeliverDetailDto ipOrderDeliverDetailDto = null;
            for (IpOrderDeliverVo orderDeliverVo : orderDeliverVos) {
                ipOrderDeliverDetailDto = new IpOrderDeliverDetailDto();
                ipOrderDeliverDetailDto.setDeliverId(orderDeliverVo.getId());
                orderDeliverVo.setGoods(this.getOrderDeliverGood(ipOrderDeliverDetailDto));
            }
        }
        PageInfo pageInfo = new PageInfo<>(orderDeliverVos);
        return pageInfo;
    }

    /**
     * 根据单号ID查询送货单信息
     *
     * @param ipOrderDeliverSearchDto
     * @return
     */
    @Override
    public IpOrderDeliverVo getDeliverDetail(IpOrderDeliverSearchDto ipOrderDeliverSearchDto) {
        //获取送货单主数据
        IpOrderDeliverVo ipOrderDeliverVo = ipOrderDeliverMapper.getOrderDeliverById(ipOrderDeliverSearchDto);

        //判断物流公司编号是否为空，不为空则说明推送消息推快递100
        String logisticsCompanyCode = ipOrderDeliverVo.getLogisticsCompanyCode();
        if (StringUtils.isNotEmpty(logisticsCompanyCode)) {
            //查询物流信
            String logisticsNum = ipOrderDeliverVo.getLogisticsNum();
            ipOrderDeliverVo.setLogistics(this.getLogistics(logisticsNum));
        }
        //获取送货单商品信息
        IpOrderDeliverDetailDto ipOrderDeliverDetailDto = new IpOrderDeliverDetailDto();
        ipOrderDeliverDetailDto.setDeliverId(ipOrderDeliverSearchDto.getDeliverId());

        ipOrderDeliverVo.setGoods(this.getOrderDeliverGood(ipOrderDeliverDetailDto));

        return ipOrderDeliverVo;
    }
    /**
    * 获取物流信息
    * @Param:  * @param logisticsNum
    * @return: java.util.List<com.ekingwin.bas.cloud.vo.IpDeliverLogisticsVo>
    * @Author: zhangjie
    * @Date: 2019/10/28 17:33
    */
    @Override
    public List<IpDeliverLogisticsVo> getLogistics(String logisticsNum) {
        List<IpDeliverLogisticsVo> logisticsByNum = ipOrderDeliverMapper.getLogisticsByNum(logisticsNum);
        return logisticsByNum;
    }

    /**
     * 根据单号ID查询送货单信息
     *
     * @param ipOrderDeliverSearchDto
     * @return
     */
    @Override
    public IpOrderDeliverVo getDeliverDetailMobile(IpOrderDeliverSearchDto ipOrderDeliverSearchDto) {
        //获取送货单主数据
        IpOrderDeliverVo ipOrderDeliverVo = ipOrderDeliverMapper.getOrderDeliverById(ipOrderDeliverSearchDto);

        //判断物流公司编号是否为空，不为空则说明推送消息推快递100
        String logisticsCompanyCode = ipOrderDeliverVo.getLogisticsCompanyCode();
        if (StringUtils.isNotEmpty(logisticsCompanyCode)) {
            //查询物流信息
            String logisticsNum = ipOrderDeliverVo.getLogisticsNum();
            ipOrderDeliverVo.setLogistics(this.getLogistics(logisticsNum));
        }
        //获取发货单的人员发货权限。
        if (StringUtils.isNotEmpty(ipOrderDeliverVo.getReceiverCodeNum())
                && StringUtils.isNotEmpty(ipOrderDeliverSearchDto.getUserid())) {
            String receiverCodeNum = ipOrderDeliverVo.getReceiverCodeNum();
            receiverCodeNum= receiverCodeNum.toLowerCase();
            String[] permitted = receiverCodeNum.split(",");

            String userId = ipOrderDeliverSearchDto.getUserid().toLowerCase();
            String inputperson = ipOrderDeliverVo.getInputperson().toLowerCase();
            if (!Arrays.asList(permitted).contains(userId) && !userId.equals(inputperson)) {
                return null;
            }
        }
        //获取送货单商品信息
        IpOrderDeliverDetailDto ipOrderDeliverDetailDto = new IpOrderDeliverDetailDto();
        ipOrderDeliverDetailDto.setDeliverId(ipOrderDeliverSearchDto.getDeliverId());
        ipOrderDeliverVo.setGoods(this.getOrderDeliverGood(ipOrderDeliverDetailDto));

        return ipOrderDeliverVo;
    }

    /**
     * 获取送货单商品信息
     *
     * @return
     */
    private List<IpOrderDeliverGoodVo> getOrderDeliverGood(IpOrderDeliverDetailDto ipOrderDeliverDetailDto) {
        List<IpOrderDeliverGoodVo> deliverGoodVoList =
                ipOrderDeliverGoodMapper.getOrderDeliverGood(ipOrderDeliverDetailDto);
        for (IpOrderDeliverGoodVo ipOrderDeliverGoodVo : deliverGoodVoList) {
            ipOrderDeliverGoodVo.setUrlPath(basPath + ipOrderDeliverGoodVo.getUrlPath());
        }

        return deliverGoodVoList;
    }

    /**
     * 保存物流信息
     *
     * @param detail
     * @param deliverId
     * @param userId
     */
    @Override
    public void saveLogistic(String detail, Long deliverId, String userId, String userName) {
        IpOrderDeliverLogistics ipOrderDeliverLogistics = new IpOrderDeliverLogistics();
        ipOrderDeliverLogistics.setCreateId(userId);
        ipOrderDeliverLogistics.setCreateName(userName);
        ipOrderDeliverLogistics.setDeliverId(deliverId);
        ipOrderDeliverLogistics.setHandleName(userName);
        ipOrderDeliverLogistics.setHandleTime(new Date());
        ipOrderDeliverLogistics.setRemark(detail);
        ipOrderDeliverLogisticsMapper.insertSelective(ipOrderDeliverLogistics);
    }


    /**
     * 保存物流信息
     *
     * @param ipOrderDeliverLogisticsDto
     */
    @Override
    public int saveOrUpdateLogistics(IpOrderDeliverLogisticsDto ipOrderDeliverLogisticsDto) throws Exception {
        IpOrderDeliverLogistics ipOrderDeliverLogistics = new IpOrderDeliverLogistics();
        MapObjUtil.copy(ipOrderDeliverLogisticsDto, ipOrderDeliverLogistics);
        ipOrderDeliverLogistics.setCreateId(ipOrderDeliverLogisticsDto.getUserid());
        ipOrderDeliverLogistics.setCreateName(ipOrderDeliverLogisticsDto.getUserName());
        ipOrderDeliverLogistics.setCreateTime(new Date());
        return ipOrderDeliverLogisticsMapper.insertSelective(ipOrderDeliverLogistics);
    }

    /**
     * g根据订单号和商品1编码获取物流信息
     *
     * @param ipOrderLogisticsSearchDto
     * @return
     */
    @Override
    public List<IpOrderDeliverVo> getOrderDeliverByOrderNum(IpOrderLogisticsSearchDto ipOrderLogisticsSearchDto) {

        List<IpOrderDeliverVo> list = ipOrderDeliverMapper.getOrderDeliverByOrderNum(ipOrderLogisticsSearchDto);
        if (list != null && list.size() > 0) {
            for (IpOrderDeliverVo ipOrderDeliverVo : list) {
                //判断物流公司编号是否为空，不为空则说明推送消息推快递100
                String logisticsCompanyCode = ipOrderDeliverVo.getLogisticsCompanyCode();
                if (StringUtils.isNotEmpty(logisticsCompanyCode)) {
                    //查询物流信息
                    String logisticsNum = ipOrderDeliverVo.getLogisticsNum();
                    ipOrderDeliverVo.setLogistics(this.getLogistics(logisticsNum));
                }
            }
        }

        return list;
    }

    /**
     * 修改送货单状态
     *
     * @param status
     * @param deliverId
     * @return
     */
    @Override
    public int updateStatus(String status, Long deliverId) {
        //修改送货单主表状态
        ipOrderDeliverMapper.updateStatus(status, deliverId);
        ipOrderDeliverGoodMapper.updateStatusByDeliverId(status, deliverId);
        return 1;
    }

    /**
     * 修改发货单的商品收货数量
     *
     * @param ipOrderGoodsStatusDto
     * @return
     */
    @Override
    public int updateGoodsStatus(IpOrderGoodsStatusDto ipOrderGoodsStatusDto) {

        return ipOrderDeliverGoodMapper.updateGoodsStatus(ipOrderGoodsStatusDto);
    }

    /**
     * 个人收货修改发货单商品的状态和数量
     *
     * @param status
     * @Param: * @param list
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/15 14:40
     */
    @Override
    public void updateGrDeliverGoodsStatus(List<IpOrderReceiveGoodDto> list, String status) {

        ipOrderDeliverGoodMapper.updateGrDeliverGoodsStatus(list, status);
    }

}
