package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.*;
import com.ekingwin.bas.cloud.dto.IpOrderAddDto;
import com.ekingwin.bas.cloud.dto.IpOrderDetailDto;
import com.ekingwin.bas.cloud.dto.IpOrderGoodDraftsDto;
import com.ekingwin.bas.cloud.dto.IpcOrderDraftsAttachmentDto;
import com.ekingwin.bas.cloud.entity.*;
import com.ekingwin.bas.cloud.service.IpOrderDrafterService;
import com.ekingwin.bas.cloud.util.DateUtils;
import com.ekingwin.bas.cloud.util.MapObjUtil;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpOrderCarDetailVo;
import com.ekingwin.bas.cloud.vo.IpOrderGoodsDetailVo;
import com.ekingwin.bas.cloud.vo.IpOrderVo;
import com.ekingwin.bas.cloud.vo.IpcOrderDraftsAttachmentVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:保存草稿
 * @author: zhangjie
 * @create: 2019-07-01 16:26
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpOrderDrafterServiceImpl implements IpOrderDrafterService {


    @Autowired
    private IpcDraftMapper ipcDraftMapper;

    @Autowired
    private IpcOrderDraftsMapper ipcOrderDraftsMapper;

    @Autowired
    private IpcOrderDraftsAttachmentMapper ipcOrderDraftsAttachmentMapper;

    @Autowired
    private IpcOrderDraftsInvoiceMapper ipcOrderDraftsInvoiceMapper;

    @Autowired
    private IpcOrderGoodsDraftsMapper ipcOrderGoodsDraftsMapper;


    @Autowired
    private IpOrderMapper ipOrderMapper;


    @Value("${goods.baseurl}")
    private String basPath;
    /**
     * 1.存草稿
     * 2.
     */
    @Override
    public Integer saveOrUpdateDraft(IpOrderAddDto ipOrderAddDto) throws Exception {
        /**
         * 保存主搞
         */
        Integer drafid = this.saveDraft(ipOrderAddDto);

        /**
         * 保存订单主表数据
         */
        this.saveOrderDraft(ipOrderAddDto, drafid);

        /**
         * 保存附件信息
         */
        this.saveOrderAttement(ipOrderAddDto,drafid);

        /**
         * 保存开票信息
         */
        this.saveInvoce(ipOrderAddDto,drafid);

        /**
         * 保存商品信息
         */
        this.saveOrdergood(ipOrderAddDto,drafid);

        return  drafid;
    }

    /**
     * 保存草稿主表
     *
     * @return
     */
    private Integer saveDraft(IpOrderAddDto ipOrderAddDto) {
        IpcDraft ipcDraft = new IpcDraft();
        ipcDraft.setTitle(ipOrderAddDto.getDrafTittle());
        ipcDraft.setType(ipOrderAddDto.getType());
        ipcDraft.setUserid(ipOrderAddDto.getUserid());
        ipcDraft.setCreatedate(DateUtils.format(new Date(), DateUtils.DATE_TIME_PATTERN));

        //判断草稿
        Integer drafeid = ipOrderAddDto.getDraftId();

        if (drafeid == null || drafeid==0) {
            ipcDraftMapper.insertSelective(ipcDraft);
            drafeid = ipcDraft.getId();
        }
        return drafeid;
    }

    /**
     * 保存草稿订单主表
     *
     * @param ipOrderAddDto
     * @param drafeid
     * @throws Exception
     */
    private void saveOrderDraft(IpOrderAddDto ipOrderAddDto, Integer drafeid) throws Exception {

        //保存草稿订单主表
        ipcOrderDraftsMapper.deleteByDraftsid(drafeid);

        IpcOrderDraftsWithBLOBs ipcOrderDrafts = new IpcOrderDraftsWithBLOBs();
        MapObjUtil.copy(ipOrderAddDto.getOrder(), ipcOrderDrafts);
         ipcOrderDrafts.setDraftsid(drafeid);
        ipcOrderDrafts.setInputperson(ipOrderAddDto.getUserid());
        ipcOrderDrafts.setInputdate(DateUtils.format(new Date(), DateUtils.DATE_TIME_PATTERN));
        ipcOrderDraftsMapper.insertSelective(ipcOrderDrafts);

    }

    /**
     * 保存附件信息
     *
     * @param ipOrderAddDto
     * @param drafeid
     * @throws Exception
     */
    private void saveOrderAttement(IpOrderAddDto ipOrderAddDto, Integer drafeid) throws Exception {
        //删除草稿数据
        ipcOrderDraftsAttachmentMapper.deleteByDraftsid(drafeid);

        //获取附件信息
        List<IpcOrderDraftsAttachmentDto> dtoAttachments = ipOrderAddDto.getAttachments();

        if (dtoAttachments != null && dtoAttachments.size() > 0) {
            IpcOrderDraftsAttachment ipcOrderDraftsAttachment = null;
            for (IpcOrderDraftsAttachmentDto dtoAttachment : dtoAttachments) {
                ipcOrderDraftsAttachment = new IpcOrderDraftsAttachment();
                MapObjUtil.copy(dtoAttachment, ipcOrderDraftsAttachment);
                ipcOrderDraftsAttachment.setDraftsid(drafeid);
                ipcOrderDraftsAttachmentMapper.insertSelective(ipcOrderDraftsAttachment);
            }
        }
    }


    /***
     * 保存草稿开票信息
     * @param ipOrderAddDto
     * @param drafeid
     * @throws Exception
     */
    private void saveInvoce(IpOrderAddDto ipOrderAddDto, Integer drafeid) throws Exception {

        ipcOrderDraftsInvoiceMapper.deleteByDraftsid(drafeid);

        IpcOrderDraftsInvoice ipcOrderDraftsInvoice = new IpcOrderDraftsInvoice();

        if (ipOrderAddDto.getInvoiceinfo() !=null){
            MapObjUtil.copy(ipOrderAddDto.getInvoiceinfo(), ipcOrderDraftsInvoice);
            ipcOrderDraftsInvoice.setDraftsid(Long.parseLong(drafeid.toString()));
            ipcOrderDraftsInvoiceMapper.insertSelective(ipcOrderDraftsInvoice);
        }
    }

    /**
     * 保存商品信息
     *
     * @param ipOrderAddDto
     * @param drafeid
     */
    private void saveOrdergood(IpOrderAddDto ipOrderAddDto, Integer drafeid) throws Exception {
        ipcOrderGoodsDraftsMapper.deleteByDraftsid(drafeid);
        List<IpOrderGoodDraftsDto> goodsList = ipOrderAddDto.getGoods();
        if (goodsList != null && goodsList.size() > 0) {
            IpcOrderGoodsDrafts orderGoodsDrafts = null;
            for (IpOrderGoodDraftsDto ipOrderGoodDraftsDto : goodsList) {
                orderGoodsDrafts = new IpcOrderGoodsDrafts();
                MapObjUtil.copy(ipOrderGoodDraftsDto, orderGoodsDrafts);
                orderGoodsDrafts.setDraftsid(drafeid);
                ipcOrderGoodsDraftsMapper.insertSelective(orderGoodsDrafts);
            }
        }

    }

    /**
     * 删除草稿数据
     * @param drafeid
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = Exception.class,isolation = Isolation.DEFAULT)
    public void  deleOrderDrafter(Integer drafeid){

        //删除草稿主数据
        ipcDraftMapper.deleteByPrimaryKey(drafeid);
        //保存草稿订单主表
        ipcOrderDraftsMapper.deleteByDraftsid(drafeid);
        //删除草稿附件
        ipcOrderDraftsAttachmentMapper.deleteByDraftsid(drafeid);
        //删除发票信息
        ipcOrderDraftsInvoiceMapper.deleteByDraftsid(drafeid);
        //删除商品信息
        ipcOrderGoodsDraftsMapper.deleteByDraftsid(drafeid);
    }

    /**
     * 获取草稿数据
     * @param ipOrderDetailDto
     * @return
     */
    @Override
    public IpOrderCarDetailVo getOrderCarDetail(IpOrderDetailDto ipOrderDetailDto) throws Exception{
        IpOrderCarDetailVo ipOrderCarDetailVo = new IpOrderCarDetailVo();
        Integer drafid=Integer.parseInt(ipOrderDetailDto.getDraftId());
        //获取草稿数据
        IpcDraft ipcDraft=ipcDraftMapper.selectByPrimaryKey(drafid);
        ipOrderCarDetailVo.setDraftId(drafid);
        ipOrderCarDetailVo.setDrafTittle(ipcDraft.getTitle());
        ipOrderCarDetailVo.setType(ipcDraft.getType());

        //获取草稿商品数据

        ipOrderCarDetailVo.setGoods(this.getOrderGoods(ipOrderDetailDto));

        //获取附件信息
        ipOrderCarDetailVo.setAttachments(this.selectAttachmentBydraftsid(drafid));
        //获取发票信息
        ipOrderCarDetailVo.setInvoiceinfo(ipcOrderDraftsInvoiceMapper.selectByDraftsid(drafid));


        ipOrderCarDetailVo.setOrder(this.getDrafftOrder(drafid));

        return  ipOrderCarDetailVo;
    }

    /**
     * 获取订单数据
     * @param drafid
     * @return
     */
    private IpOrderVo getDrafftOrder(Integer drafid) throws Exception{
        IpOrderVo ipOrderVo =new IpOrderVo();
        IpcOrderDraftsWithBLOBs ipcOrderDrafts=ipcOrderDraftsMapper.selectByDraftsid(drafid);
        if (ipcOrderDrafts !=null){
            MapObjUtil.copy(ipcOrderDrafts,ipOrderVo);
        }
        return ipOrderVo;
    }


    /**
     * 获取草稿商品数据
     * @param ipOrderDetailDto
     * @return
     */
    private List<IpOrderGoodsDetailVo> getOrderGoods(IpOrderDetailDto ipOrderDetailDto){
        List<IpOrderGoodsDetailVo> ipOrderGoodsDetailVos=ipOrderMapper.getOderGoodsDraft(ipOrderDetailDto);
        if (ipOrderGoodsDetailVos !=null && ipOrderGoodsDetailVos.size()>0){
            for (IpOrderGoodsDetailVo ipOrderGoodsDetailVo : ipOrderGoodsDetailVos) {
                if (StringUtils.isNotEmpty(ipOrderGoodsDetailVo.getUrlPath())){
                    ipOrderGoodsDetailVo.setUrlPath(basPath+ipOrderGoodsDetailVo.getUrlPath());
                }

            }
        }
        return ipOrderGoodsDetailVos;
    }

    /**
     * 获取附件信息
     * @param drafid
     * @return
     */
    private List<IpcOrderDraftsAttachmentVo> selectAttachmentBydraftsid(Integer drafid){

        return  ipcOrderDraftsAttachmentMapper.selectBydraftsid(drafid);
    }

    @Override
    public IpcOrderDraftsWithBLOBs getOrderDrafts(Integer id){

        return  ipcOrderDraftsMapper.selectByDraftsid(id);
    }
}
