package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpOrderReceiveGoodsMapper;
import com.ekingwin.bas.cloud.dao.IpOrderReceiveMapper;
import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.dto.tick.SettlementDetailsReq;
import com.ekingwin.bas.cloud.dto.tick.SettlementMainReq;
import com.ekingwin.bas.cloud.dto.tick.SettlementReq;
import com.ekingwin.bas.cloud.entity.IpOrderReceive;
import com.ekingwin.bas.cloud.entity.IpOrderReceiveGoods;
import com.ekingwin.bas.cloud.entity.IpcOrderAllgoods;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationDto;
import com.ekingwin.bas.cloud.process.dto.ApprovetaskDto;
import com.ekingwin.bas.cloud.process.dto.CreateProcessDto;
import com.ekingwin.bas.cloud.process.dto.ResultProcessTodoListDto;
import com.ekingwin.bas.cloud.process.dto.TodoListDto;
import com.ekingwin.bas.cloud.process.service.IpcProcessService;
import com.ekingwin.bas.cloud.rabbit.sender.OrderReceiverSender;
import com.ekingwin.bas.cloud.rabbit.sender.ReconciliationOrderSender;
import com.ekingwin.bas.cloud.rabbit.sender.TicketSender;
import com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode;
import com.ekingwin.bas.cloud.service.IpOrderDeliverService;
import com.ekingwin.bas.cloud.service.IpOrderReceiverService;
import com.ekingwin.bas.cloud.service.IpcOrderService;
import com.ekingwin.bas.cloud.util.DateUtils;
import com.ekingwin.bas.cloud.util.MapObjUtil;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-07 15:36
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpOrderReceiverServiceImpl implements IpOrderReceiverService {


    @Autowired
    private IpOrderReceiveGoodsMapper ipOrderReceiveGoodsMapper;

    @Autowired
    private IpOrderReceiveMapper ipOrderReceiveMapper;

    @Autowired
    private IpcOrderService ipcOrderService;

    @Autowired
    private IpcProcessService ipcProcessService;

    @Autowired
    private IpOrderDeliverService ipOrderDeliverService;

    @Autowired
    private ReconciliationOrderSender reconciliationOrderSender;

    @Value("${goods.baseurl}")
    private String basPath;

    @Autowired
    private TicketSender ticketSender;

    @Autowired
    private OrderReceiverSender orderReceiverSender;

    /**
     * 保存发货单数据
     *
     * @param ipOrderReceiverDto
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public String saveReceiver(IpOrderReceiverDto ipOrderReceiverDto) throws Exception {
        String instid = null;
        int status = ipOrderReceiverDto.getStatus();
        //收货
        if (status == 1) {
            //判断是否在收货中
            if (StringUtils.isNotEmpty(ipOrderReceiverDto.getInstid())) {
                this.approvalUpdate(ipOrderReceiverDto);
            } else {
                instid = this.receiverPass(ipOrderReceiverDto);
            }

        } else if (status == -1) {
            //拒收
            this.receiverReject(ipOrderReceiverDto);
        }

        return instid;
    }

    /**
     * 收货拒绝
     */
    private void receiverReject(IpOrderReceiverDto ipOrderReceiverDto) throws Exception {
        /**
         * 保存收货单主数据
         */
        String createId = ipOrderReceiverDto.getUserid();
        IpOrderReceive ipOrderReceive = new IpOrderReceive();
        ipOrderReceive.setCreateId(createId);
        ipOrderReceive.setCreateTime(new Date());
        ipOrderReceive.setCreateName(ipOrderReceiverDto.getUserName());
        ipOrderReceive.setDeliverId(ipOrderReceiverDto.getDeliverId());
        //拒收
        ipOrderReceive.setStatus(-2);
        ipOrderReceiveMapper.insertSelective(ipOrderReceive);
        Long id = ipOrderReceive.getId();

        List<IpOrderReceiveGoodDto> goods = ipOrderReceiverDto.getGoods();
        Long deliverId = ipOrderReceiverDto.getDeliverId();
        if (goods != null && goods.size() > 0) {
            IpOrderReceiveGoods ipOrderReceiveGoods = null;
            IpOrderGoodsStatusDto ipOrderGoodsStatusDto = null;
            for (IpOrderReceiveGoodDto good : goods) {
                ipOrderGoodsStatusDto = new IpOrderGoodsStatusDto();
                ipOrderReceiveGoods = new IpOrderReceiveGoods();
                String orderGoodsId = good.getOrderGoodsId();
                ipOrderGoodsStatusDto.setOrderGoodsId(orderGoodsId);
                MapObjUtil.copy(good, ipOrderReceiveGoods);
                ipOrderReceiveGoods.setReceiverId(id);
                ipOrderReceiveGoodsMapper.insertSelective(ipOrderReceiveGoods);


                //判断收货状态
                BigDecimal wshNum = good.getWshnum();
                BigDecimal bigDecimal = new BigDecimal("-1");
                ipOrderGoodsStatusDto.setGoodsDeliver(wshNum.multiply(bigDecimal));


                //获取已发货数量

                BigDecimal deliverGoods = ipcOrderService.getDeliverGoods(orderGoodsId);
                if (deliverGoods == null || deliverGoods.compareTo(wshNum) != 1) {
                    ipOrderGoodsStatusDto.setStatus("待发货");
                } else {
                    ipOrderGoodsStatusDto.setStatus("部分发货");
                }

                ipOrderGoodsStatusDto.setDeliverId(deliverId);
                ipcOrderService.updateGoodsDeliverCount(ipOrderGoodsStatusDto);

            }

        }
        //修改发货单的状态
        ipOrderDeliverService.updateStatus("拒收", deliverId);
    }

    /**
     * 收货pass
     */
    private String receiverPass(IpOrderReceiverDto ipOrderReceiverDto) throws Exception {
        String customerType = ipOrderReceiverDto.getCustomerType();
        String orderType = ipOrderReceiverDto.getOrderType();
        //若为项目验证是否收货
        if ((StringUtils.isEmpty(customerType) || "XM".equals(customerType)) && "XM".equals(orderType)) {
            boolean flag = this.bulidApproveTask(ipOrderReceiverDto);
            if (!flag) {
                throw new BusinessException(500, "您已经确认收货，请勿重复操作");
            }
        } else {
            List<IpOrderReceiveGoodDto> goods = ipOrderReceiverDto.getGoods();
            if (goods == null || goods.size() == 0) {
                throw new BusinessException(500, "请选择收货商品");
            }
            for (IpOrderReceiveGoodDto good : goods) {
                String orderGoodsId = good.getOrderGoodsId();
                //获取商品明细
                IpcOrderAllgoods orderGoods = ipcOrderService.getOrderGoods(orderGoodsId);
                String state = orderGoods.getState();
                if (orderGoods != null && ("已收货".equals(state) || "退货中".equals(state) || "已退货".equals(state))) {
                    throw new BusinessException(500, "您已经确认收货，请勿重复操作");
                }
            }
        }


        /**
         * 保存收货单主数据
         */
        String createId = ipOrderReceiverDto.getUserid();
        IpOrderReceive ipOrderReceive = new IpOrderReceive();
        ipOrderReceive.setCreateId(createId);
        ipOrderReceive.setCreateTime(new Date());
        ipOrderReceive.setCreateName(ipOrderReceiverDto.getUserName());
        //生成订单号
        // String receiverNum = ipOrderReceiveMapper.getReceiverNum();
        String receiverNum = GenerateRequestCode.requestCode("orderReceiver", GenerateRequestCode.YEARMONTHDAY, 4, "SHDH");
        ipOrderReceive.setReceiverNum(receiverNum);
        ipOrderReceive.setDeliverId(ipOrderReceiverDto.getDeliverId());
        ipOrderReceiveMapper.insertSelective(ipOrderReceive);
        Long id = ipOrderReceive.getId();


        //保存收货单商品信息
        List<IpOrderReceiveGoodDto> goods = ipOrderReceiverDto.getGoods();
        if (goods != null && goods.size() > 0) {
            this.saveReceiverGoods(goods, id);
        }
        String instid = null;
        /**
         *判断是否项目订单还是个人订单
         * 若为项目订单需发起流程审批四方确认
         * 若为个人订单则只需确认收货即可
         */
        if ((StringUtils.isNotEmpty(customerType) && "GR".equals(customerType)) || "XZ".equals(orderType)) {
            if ("XZ".equals(orderType)) {
                this.initXzReceiver(ipOrderReceiverDto);
            } else {
                //修改发货单商品状态
                this.initReceiverGrOrder(goods);
            }


            //同步数据到运营表
            this.initReceiverMonitor(ipOrderReceiverDto, receiverNum);
            if ("GR".equals(orderType)) {
                //同步数据到票易通
                this.initReceiverInvoice(ipOrderReceiverDto, receiverNum);
            }

        } else {
            //处理项目类收货订单
            instid = this.checkReceiverXmOrder(ipOrderReceiverDto, ipOrderReceive);
        }
        return instid;
    }

    private void initXzReceiver(IpOrderReceiverDto ipOrderReceiverDto) {
        ipOrderDeliverService.updateStatus("已收货", ipOrderReceiverDto.getDeliverId());
        ipOrderDeliverService.saveLogistic("该订单确认收货", ipOrderReceiverDto.getDeliverId(), null, null
        );

        List<IpOrderReceiveGoodDto> goods1 = ipOrderReceiverDto.getGoods();
        Long deliverId = ipOrderReceiverDto.getDeliverId();

        if (goods1.size() > 0) {
            IpOrderGoodsStatusDto ipOrderGoodsStatusDto = null;
            for (IpOrderReceiveGoodDto goodDto : goods1) {
                ipOrderGoodsStatusDto = new IpOrderGoodsStatusDto();
                BigDecimal sumNum = goodDto.getSumnum();
                BigDecimal yshnum = goodDto.getYshnum();
                if (StringUtils.isEmpty(yshnum)) {
                    yshnum = new BigDecimal("0.00");
                }
                BigDecimal receverNum = goodDto.getReceverNum();
                if (StringUtils.isEmpty(receverNum)) {
                    receverNum = new BigDecimal("0");
                }
                ipOrderGoodsStatusDto.setOrderGoodsId(goodDto.getOrderGoodsId().toString());
                ipOrderGoodsStatusDto.setGoodsReceived(receverNum);

                BigDecimal receiverGoods = ipcOrderService.getReceiverGoods(goodDto.getOrderGoodsId());
                if (receiverGoods == null) {
                    receiverGoods = new BigDecimal("0");
                }
                if (sumNum.compareTo(receverNum.add(receiverGoods)) != 1) {
                    ipOrderGoodsStatusDto.setStatus("已收货");
                }
                ipOrderGoodsStatusDto.setDeliverId(deliverId);
                BigDecimal wshNum = goodDto.getWshnum();

                //判断收货数量是否小于发货数量，如果小于，则减少已发货数量
                if (receverNum.compareTo(wshNum) == -1) {
                    ipOrderGoodsStatusDto.setStatus("部分发货");
                    ipOrderGoodsStatusDto.setGoodsDeliver(receverNum.subtract(wshNum));
                }
                ipcOrderService.updateGoodsStatus1(ipOrderGoodsStatusDto);

                ipOrderDeliverService.updateGoodsStatus(ipOrderGoodsStatusDto);
            }
        }
    }

    /**
     * 将收货信息初始化运营信息表中
     * @param ipOrderReceiverDto
     * @param receiverNum
     * @throws Exception
     */
    private void initReceiverMonitor(IpOrderReceiverDto ipOrderReceiverDto, String receiverNum) throws Exception {
        List<IpOrderReceiveGoodDto> goods = ipOrderReceiverDto.getGoods();
        if (goods != null && goods.size() > 0) {
            List<IpOrderReconciliationDto> reconciliationDtos = new ArrayList<IpOrderReconciliationDto>();
            IpOrderReconciliationDto ipOrderReconciliationDto = null;
            for (IpOrderReceiveGoodDto good : goods) {
                ipOrderReconciliationDto = new IpOrderReconciliationDto();
                String orderGoodsId = good.getOrderGoodsId();
                ipOrderReconciliationDto.setOrderGoodsId(orderGoodsId);
                BigDecimal yshnum = good.getYshnum();
                if (yshnum == null) {
                    yshnum = new BigDecimal("0.00");
                }
                ipOrderReconciliationDto.setReceiverNum(yshnum.toString());
                ipOrderReconciliationDto.setOrderAccount(good.getSumnum().toString());
                BigDecimal receverNum = good.getReceverNum();
                if (receverNum == null) {
                    receverNum = new BigDecimal("0.00");
                }
                ipOrderReconciliationDto.setAccount(receverNum.toString());
                //根据订单商品id获取商品明细
                IpcOrderAllgoods orderGoods = ipcOrderService.getOrderGoods(orderGoodsId);
                Long orderid = orderGoods.getOrderid();
                //获取订单明细
                IpOrderVo orderDetaiil = ipcOrderService.getOrderDetaiil(orderid);
                ipOrderReconciliationDto.setGoodsId(orderGoods.getGoodsid().toString());
                ipOrderReconciliationDto.setGoodsName(orderGoods.getGoodsname());
                ipOrderReconciliationDto.setOrderId(orderid.toString());
                ipOrderReconciliationDto.setGoodsnum(orderGoods.getGoodsnum());
                ipOrderReconciliationDto.setOrderNum(orderDetaiil.getOrdernum());
                ipOrderReconciliationDto.setOrderPersion(orderDetaiil.getApplyUser());

                ipOrderReconciliationDto.setOrderTime(DateUtils.stringToDate(orderDetaiil.getApplyTime(), DateUtils.DATE_TIME_PATTERN));
                ipOrderReconciliationDto.setOrderPersionCode(orderDetaiil.getApplyCode());
                ipOrderReconciliationDto.setOrderPersion(orderDetaiil.getApplyUser());
                String price = orderGoods.getPrice();
                BigDecimal bigPrice = new BigDecimal(price);
                if (bigPrice == null) {
                    bigPrice = new BigDecimal("0.00");
                }
                ipOrderReconciliationDto.setOrderPrice(bigPrice);
                BigDecimal totalPrice = bigPrice.multiply(receverNum);
                ipOrderReconciliationDto.setTotalPrice(totalPrice);
                ipOrderReconciliationDto.setRate(orderGoods.getTaxrate());
                String rmbhsprice = orderGoods.getRmbhsprice();
                if (StringUtils.isEmpty(rmbhsprice)) {
                    rmbhsprice = "0.00";
                }
                BigDecimal rmbhsPrice = new BigDecimal(rmbhsprice);
                if (rmbhsPrice == null) {
                    rmbhsPrice = new BigDecimal("0.00");
                }
                //供应商总计 原价乘以收货数量
                BigDecimal supplicePrice = rmbhsPrice.multiply(receverNum);
                ipOrderReconciliationDto.setPrice(bigPrice);
                ipOrderReconciliationDto.setSupplierPrice(rmbhsPrice);
                ipOrderReconciliationDto.setSupplierTotalPrice(supplicePrice);

                String rmbbhsprice = orderGoods.getRmbbhsprice();
                if (StringUtils.isEmpty(rmbbhsprice)) {
                    rmbbhsprice = "0.00";
                }
                BigDecimal rmbbhsPrice = new BigDecimal(rmbbhsprice);
                if (rmbbhsPrice == null) {
                    rmbbhsPrice = new BigDecimal("0.00");
                }
                String bhspriceStr = orderGoods.getBhsprice();
                if (StringUtils.isEmpty(bhspriceStr)) {
                    bhspriceStr = "0.00";
                }
                BigDecimal bhsprice = new BigDecimal(bhspriceStr);
                if (bhsprice == null) {
                    bhsprice = new BigDecimal("0.00");
                }
                ipOrderReconciliationDto.setNotaxPrice(bhsprice);
                ipOrderReconciliationDto.setSupplierNotaxprice(rmbbhsPrice);
                BigDecimal total = new BigDecimal(orderGoods.getGoodstotalhsprice());
                ipOrderReconciliationDto.setOrderTotalPrice(total);
                ipOrderReconciliationDto.setType("SH");
                ipOrderReconciliationDto.setSupplierId(orderGoods.getSupplierid());
                ipOrderReconciliationDto.setSupplierName(orderGoods.getSupplier());
                ipOrderReconciliationDto.setSupplierNum(orderGoods.getSupplierid());
                ipOrderReconciliationDto.setOrderType(orderDetaiil.getOrderType());
                ipOrderReconciliationDto.setProfitMargin(totalPrice.subtract(supplicePrice));
                reconciliationDtos.add(ipOrderReconciliationDto);
            }
            if (reconciliationDtos != null && reconciliationDtos.size() > 0) {
                String toString = JSONArray.fromObject(reconciliationDtos).toString();
                reconciliationOrderSender.send("order.monitororder.info", toString);
            }
        }
    }


    /**
     * 推送消息进票易通
     *
     * @Param: * @param ipOrderReceiverDto
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/31 16:42
     */
    @Override
    public void initReceiverInvoice(IpOrderReceiverDto ipOrderReceiverDto, String receiverNum) throws
            Exception {
        SettlementReq settlementReq = new SettlementReq();
        settlementReq.setReceiverNum(receiverNum);

        //获取发票主表明细
        List<SettlementMainReq> invoiceMain = ipOrderReceiveMapper.getInvoiceMain(ipOrderReceiverDto);
        if (invoiceMain != null && invoiceMain.size() > 0) {
            SettlementMainReq settlementMainReq = invoiceMain.get(0);
            settlementReq.setSettlementMain(settlementMainReq);
            settlementReq.setOrdernum(settlementMainReq.getOrdernum());
            settlementReq.setContactid(settlementMainReq.getClearingcorpcode());
            //获取发票开票明细
            List<SettlementDetailsReq> orderGoodsInvoice = ipOrderReceiveMapper.getOrderGoodsInvoice(ipOrderReceiverDto);
            settlementReq.setSettlementDetails(orderGoodsInvoice);
        }

        String string = JSONObject.fromObject(settlementReq).toString();
        ticketSender.send("order.ticket.info", string);
    }

    /**
     * 个人修改收货单商品数量
     *
     * @Param: * @param goods
     * @return: java.lang.String
     * @Author: zhangjie
     * @Date: 2019/10/15 14:43
     */
    private String initReceiverGrOrder(List<IpOrderReceiveGoodDto> goods) {
        //修改发货单商品状态
        ipOrderDeliverService.updateGrDeliverGoodsStatus(goods, "已收货");
        //修改订单商品状态
        ipcOrderService.updateGoodsReceiverList(goods);
        return null;
    }

    /**
     * 处理项目类收货逻辑
     *
     * @Param: * @param
     * @return: java.lang.String
     * @Author: zhangjie
     * @Date: 2019/10/15 13:55
     */
    private String checkReceiverXmOrder(IpOrderReceiverDto ipOrderReceiverDto, IpOrderReceive ipOrderReceive) throws Exception {
        String userId = ipOrderReceiverDto.getUserid();
        Long deliverId = ipOrderReceiverDto.getDeliverId();
        IpOrderDeliverSearchDto ipOrderDeliverSearchDto = new IpOrderDeliverSearchDto();
        ipOrderDeliverSearchDto.setDeliverId(deliverId);
        ipOrderDeliverSearchDto.setUserid(userId);
        //获取发货单信息
        IpOrderDeliverVo ipOrderDeliverVo = ipOrderDeliverService.getDeliverDetail(ipOrderDeliverSearchDto);
        //获取审批人员
        String receiverCode = this.getReceiverNum(ipOrderDeliverVo, userId);
        //发起流程
        String instid = this.startProcess(ipOrderReceiverDto, ipOrderDeliverVo, receiverCode);
        ipOrderReceive.setInstid(instid);
        ipOrderReceiveMapper.updateByPrimaryKeySelective(ipOrderReceive);

        //修改发货单的状态
        ipOrderDeliverService.updateStatus("审批中", deliverId);

        return instid;
    }

    /**
     * 保存收货的商品信息
     *
     * @param id
     * @Param: * @param goods
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/15 13:53
     */
    private void saveReceiverGoods(List<IpOrderReceiveGoodDto> goods, Long id) throws Exception {
        IpOrderReceiveGoods ipOrderReceiveGoods = null;
        for (IpOrderReceiveGoodDto good : goods) {
            ipOrderReceiveGoods = new IpOrderReceiveGoods();
            MapObjUtil.copy(good, ipOrderReceiveGoods);
            ipOrderReceiveGoods.setReceiverId(id);
            ipOrderReceiveGoodsMapper.insertSelective(ipOrderReceiveGoods);
        }
    }

    /**
     * 修改收货单数据
     *
     * @param ipOrderReceiverDto
     */
    private void approvalUpdate(IpOrderReceiverDto ipOrderReceiverDto) throws Exception {

        //根据流程实例号获取收货单信息
        IpOrderReceive ipOrderReceive = ipOrderReceiveMapper.selectByInstid(ipOrderReceiverDto.getInstid());
        List<IpOrderReceiveGoodDto> goods = ipOrderReceiverDto.getGoods();
        Long id = ipOrderReceive.getId();
        ipOrderReceiveGoodsMapper.deleteByReceiverId(id);
        if (goods != null && goods.size() > 0) {
            IpOrderReceiveGoods ipOrderReceiveGoods = null;
            for (IpOrderReceiveGoodDto good : goods) {
                ipOrderReceiveGoods = new IpOrderReceiveGoods();
                MapObjUtil.copy(good, ipOrderReceiveGoods);
                ipOrderReceiveGoods.setReceiverId(id);
                ipOrderReceiveGoodsMapper.insertSelective(ipOrderReceiveGoods);

            }
        }

    }

    /**
     * 获取审批人信息
     *
     * @return
     */
    private String getReceiverNum(IpOrderDeliverVo ipOrderDeliverVo, String createId) {

        Set set = new HashSet();
        //根据1D获取收货单详情
        //项目负责人
        if (StringUtils.isNotEmpty(ipOrderDeliverVo.getProjectLeaderCode())) {
            String[] leaderCode = ipOrderDeliverVo.getProjectLeaderCode().split(",");
            for (String s : leaderCode) {
                set.add(s);
            }

        }

        //监理
        if (StringUtils.isNotEmpty(ipOrderDeliverVo.getSupervisorCode())) {
            String[] superCode = ipOrderDeliverVo.getSupervisorCode().split(",");
            for (String s : superCode) {
                set.add(s);
            }

        }
        List<IpOrderDeliverGoodVo> goods = ipOrderDeliverVo.getGoods();
        IpOrderDeliverGoodVo ipOrderDeliverGoodVo = goods.get(0);
        String supportCode = ipOrderDeliverGoodVo.getSupportCode();
        //收货方，甲分包不需收货方审批
        if (StringUtils.isNotEmpty(supportCode) && !"02".equals(supportCode)) {

            if (StringUtils.isNotEmpty(ipOrderDeliverVo.getReceiverCodes())) {
                String[] strs = ipOrderDeliverVo.getReceiverCodes().split(",");
                for (String str : strs) {
                    set.add(str);
                }
            }
        }

        set.remove(createId);
        return String.join(",", set);
    }

    /**
     * 流程发起
     *
     * @param ipOrderReceiverDto
     * @param ipOrderDeliverVo
     * @param receiverCode
     * @return
     * @throws Exception
     */
    private String startProcess(IpOrderReceiverDto ipOrderReceiverDto,
                                IpOrderDeliverVo ipOrderDeliverVo, String receiverCode) throws Exception {
        String userId = ipOrderReceiverDto.getUserid();
        CreateProcessDto createProcessDto = new CreateProcessDto();
        createProcessDto.setProcessName("QRSH");
        createProcessDto.setUserId(userId);
        createProcessDto.setReqNo(ipOrderDeliverVo.getDeliverNum());
        createProcessDto.setSubject(this.getSubject(ipOrderReceiverDto.getDeliverId(), userId));
        Map<String, Object> map = new HashMap<>();
        map.put("USERS", receiverCode);
        map.put("XMFZR", ipOrderDeliverVo.getProjectLeaderCode());
        map.put("GYSQR", ipOrderDeliverVo.getSupplieraccount());
        createProcessDto.setBusinessData(map);
        String instid = ipcProcessService.createProcess(createProcessDto);
        return instid;
    }

    /**
     * 流程审批结束更新
     *
     * @param instid
     */
    @Override
    public void initPass(String instid) throws Exception {
        //根据流程实例号获取收货单信息
        IpOrderReceive ipOrderReceive = ipOrderReceiveMapper.selectByInstid(instid);
        ipOrderDeliverService.updateStatus("已收货", ipOrderReceive.getDeliverId());
        ipOrderDeliverService.saveLogistic("该订单确认收货", ipOrderReceive.getDeliverId(), null, null);

        List<IpOrderReceiveGoods> list = ipOrderReceive.getReceiveGoods();
        Long deliverId = ipOrderReceive.getDeliverId();

        if (list.size() > 0) {
            IpOrderGoodsStatusDto ipOrderGoodsStatusDto = null;
            for (IpOrderReceiveGoods ipOrderReceiveGoods : list) {
                ipOrderGoodsStatusDto = new IpOrderGoodsStatusDto();
                BigDecimal sumNum = ipOrderReceiveGoods.getSumnum();
                BigDecimal yshnum = ipOrderReceiveGoods.getYshnum();
                if (StringUtils.isEmpty(yshnum)) {
                    yshnum = new BigDecimal("0.00");
                }
                BigDecimal receverNum = ipOrderReceiveGoods.getReceverNum();
                if (StringUtils.isEmpty(receverNum)) {
                    receverNum = new BigDecimal("0.00");
                }
                ipOrderGoodsStatusDto.setOrderGoodsId(ipOrderReceiveGoods.getOrderGoodsId().toString());
                ipOrderGoodsStatusDto.setGoodsReceived(receverNum);

                //获取商品收货数量
                BigDecimal receiverGoods = ipcOrderService.getReceiverGoods(ipOrderReceiveGoods.getOrderGoodsId());
                if (receiverGoods == null) {
                    receiverGoods = new BigDecimal("0");
                }
                if (sumNum.compareTo(receverNum.add(receiverGoods)) != 1) {
                    ipOrderGoodsStatusDto.setStatus("已收货");
                }
                ipOrderGoodsStatusDto.setDeliverId(deliverId);
                BigDecimal wshNum = ipOrderReceiveGoods.getWshnum();

                //判断收货数量是否小于发货数量，如果小于，则减少已发货数量
                if (receverNum.compareTo(wshNum) == -1) {
                    ipOrderGoodsStatusDto.setStatus("部分发货");
                    ipOrderGoodsStatusDto.setGoodsDeliver(receverNum.subtract(wshNum));
                }
                BigDecimal zero = new BigDecimal("0.00");
                if (receverNum.add(receiverGoods).compareTo(zero) == 0) {
                    ipOrderGoodsStatusDto.setStatus("待发货");
                }
                //修改订单的状态
                ipcOrderService.updateGoodsStatus1(ipOrderGoodsStatusDto);

                //修改商品的状态
                ipOrderDeliverService.updateGoodsStatus(ipOrderGoodsStatusDto);
            }
            //同步数据到运营平台
            this.initPassReceiver(list);
            //同步项目的收货单
            this.initSapReceiver(ipOrderReceive);
        }
    }

    /**
     * 初始化sap收货数据
     * @param ipOrderReceive
     * @throws Exception
     */
    @Override
    public void initSapReceiver(IpOrderReceive ipOrderReceive) throws Exception {
        Long id = ipOrderReceive.getId();
        String receiverNum = ipOrderReceive.getReceiverNum();
        //获取sap的收货信息
        List<SapReceiverVo> sapReceiverNum = ipOrderReceiveMapper.getSapReceiverNum(id);
        if (sapReceiverNum != null && sapReceiverNum.size() > 0) {
            SapReceiverVo sapReceiverVo = sapReceiverNum.get(0);
            sapReceiverVo.setWaers("CNY");
            String format = DateUtils.format(new Date(), DateUtils.DATE_PATTERN1);
            sapReceiverVo.setTakeDat(format);
            String ordertype = sapReceiverVo.getOrdertype();
            //订单类型，若为项目的同步sap
            if (StringUtils.isEmpty(ordertype) || "XM".equals(ordertype)) {
                List<IpOrderReceiveGoods> receiveGoods = ipOrderReceive.getReceiveGoods();
                List<SapReceiverGoodsVo> goodsVos = new ArrayList<>();
                SapReceiverGoodsVo sapReceiverGoodsVo = null;
                for (IpOrderReceiveGoods receiveGood : receiveGoods) {
                    sapReceiverGoodsVo = new SapReceiverGoodsVo();
                    String orderGoodsId = receiveGood.getOrderGoodsId();
                    BigDecimal receverNum = receiveGood.getReceverNum();
                    IpcOrderAllgoods orderGoods = ipcOrderService.getOrderGoods(orderGoodsId);
                    sapReceiverGoodsVo.setGoodsName(orderGoods.getGoodsname());
                    sapReceiverGoodsVo.setGoodsNum(orderGoods.getGoodsnum());
                    sapReceiverGoodsVo.setSpecifications(orderGoods.getFtnpspecificationsmodel());
                    sapReceiverGoodsVo.setReceivingGoods(receiverNum);
                    sapReceiverGoodsVo.setSupplyType(orderGoods.getFtnpsecondcategorycode());
                    sapReceiverGoodsVo.setTaxRate(orderGoods.getTaxrate());
                    sapReceiverGoodsVo.setUnit(orderGoods.getUnit());
                    //销售含税
                    BigDecimal salePrice = new BigDecimal(orderGoods.getPrice());
                    if (salePrice == null) {
                        salePrice = new BigDecimal("0.00");
                    }
                    sapReceiverGoodsVo.setSalePrice(salePrice);

                    //销售含税
                    BigDecimal salePriceNoTax = new BigDecimal(orderGoods.getBhsprice());
                    if (salePriceNoTax == null) {
                        salePriceNoTax = new BigDecimal("0.00");
                    }
                    sapReceiverGoodsVo.setSalePriceNoTax(salePriceNoTax);

                    //不含税单价
                    String rmbbhsprice = orderGoods.getRmbbhsprice();
                    if (StringUtils.isEmpty(rmbbhsprice)) {
                        rmbbhsprice = "0.00";
                    }
                    BigDecimal priceNoTax = new BigDecimal(rmbbhsprice);
                    sapReceiverGoodsVo.setPriceNoTax(priceNoTax);


                    String rmbhsprice = orderGoods.getRmbhsprice();
                    if (StringUtils.isEmpty(rmbhsprice)) {
                        rmbhsprice = "0.00";
                    }
                    BigDecimal price = new BigDecimal(rmbhsprice);
                    sapReceiverGoodsVo.setPrice(price);
                    sapReceiverGoodsVo.setReceiverNum(receverNum);

                    sapReceiverGoodsVo.setTotalSalePrice(salePrice.multiply(receverNum));
                    sapReceiverGoodsVo.setTotalSalePriceNoTax(salePriceNoTax.multiply(receverNum));
                    sapReceiverGoodsVo.setTotalPrice(price.multiply(receverNum));
                    sapReceiverGoodsVo.setTotalPriceNoTax(priceNoTax.multiply(receverNum));
                    goodsVos.add(sapReceiverGoodsVo);
                }
                sapReceiverVo.setProducInfos(goodsVos);
                sapReceiverVo.setWaers("CNY");
                String string = JSONObject.fromObject(sapReceiverVo).toString();
                orderReceiverSender.send("saporder.orderreceiver.info", string);

            }

        }

    }

    /**
     * 流程审批通过更新收货信息
     * @param list
     * @throws Exception
     */
    private void initPassReceiver(List<IpOrderReceiveGoods> list) throws Exception {
        IpOrderReceiverDto ipOrderReceiverDto = new IpOrderReceiverDto();
        if (list != null && list.size() > 0) {
            List<IpOrderReceiveGoodDto> orderReceiveGoodDtos = new ArrayList<IpOrderReceiveGoodDto>();
            IpOrderReceiveGoodDto orderReceiveGoodDto = null;
            for (IpOrderReceiveGoods ipOrderReceiveGoods : list) {
                orderReceiveGoodDto = new IpOrderReceiveGoodDto();
                orderReceiveGoodDto.setOrderGoodsId(ipOrderReceiveGoods.getOrderGoodsId());
                orderReceiveGoodDto.setReceverNum(ipOrderReceiveGoods.getReceverNum());
                orderReceiveGoodDto.setSumnum(ipOrderReceiveGoods.getWshnum());
                orderReceiveGoodDto.setWshnum(ipOrderReceiveGoods.getWshnum());
                orderReceiveGoodDto.setYshnum(ipOrderReceiveGoods.getYshnum());
                orderReceiveGoodDtos.add(orderReceiveGoodDto);
            }
            ipOrderReceiverDto.setGoods(orderReceiveGoodDtos);
            //初始化收货信息到运营
            this.initReceiverMonitor(ipOrderReceiverDto, null);
        }

    }

    /**
     * 流程审批结束更新
     *
     * @param instid
     */

    @Override
    public void initFail(String instid) {
        //根据流程实例号获取收货信息
        IpOrderReceive ipOrderReceive = ipOrderReceiveMapper.selectByInstid(instid);
        ipOrderDeliverService.updateStatus("审批不通过", ipOrderReceive.getDeliverId());

        List<IpOrderReceiveGoods> list = ipOrderReceive.getReceiveGoods();
        Long deliverId = ipOrderReceive.getDeliverId();
        if (list.size() > 0) {
            IpOrderGoodsStatusDto ipOrderGoodsStatusDto = null;
            for (IpOrderReceiveGoods ipOrderReceiveGoods : list) {
                ipOrderGoodsStatusDto = new IpOrderGoodsStatusDto();
                BigDecimal wshNum = ipOrderReceiveGoods.getWshnum();
                //判断收货数量是否小于发货数量，如果小于，则减少已发货数量
                // if (receverNum.compareTo(wshNum)==-1){
                BigDecimal bigDecimal = new BigDecimal("-1");
                ipOrderGoodsStatusDto.setGoodsDeliver(wshNum.multiply(bigDecimal));
                ipOrderGoodsStatusDto.setOrderGoodsId(ipOrderReceiveGoods.getOrderGoodsId());
                //获取已发货数量
                BigDecimal deliverGoods = ipcOrderService.getDeliverGoods(ipOrderReceiveGoods.getOrderGoodsId());
                if (deliverGoods == null || deliverGoods.compareTo(wshNum) != 1) {
                    ipOrderGoodsStatusDto.setStatus("待发货");
                } else {
                    ipOrderGoodsStatusDto.setStatus("部分发货");
                }
                //修改商品的已发货数量和状态
                ipcOrderService.updateGoodsDeliverCount(ipOrderGoodsStatusDto);
            }
        }
    }


    /**
     * 获取发货单详情
     *
     * @param ipOrderReceiverSearchDto
     * @return
     */
    @Override
    public IpOrderReceiverVo getOrderReceiverData(IpOrderReceiverSearchDto ipOrderReceiverSearchDto) {

        //若流程实例号不为空，流程实例号获取信息
        if (StringUtils.isNotEmpty(ipOrderReceiverSearchDto.getInstid())) {
            String instid = ipOrderReceiverSearchDto.getInstid();
            IpOrderReceive ipOrderReceive = ipOrderReceiveMapper.selectByInstid(instid);
            ipOrderReceiverSearchDto.setReceiverId(ipOrderReceive.getId());
        } else if (StringUtils.isNotEmpty(ipOrderReceiverSearchDto.getDeliverId())) {
            //根据发货单id获取信息
            List<IpOrderReceive> receives = ipOrderReceiveMapper.selectByDeliverId(ipOrderReceiverSearchDto.getDeliverId());
            if (receives != null && receives.size() > 0) {
                IpOrderReceive ipOrderReceive = receives.get(0);
                ipOrderReceiverSearchDto.setReceiverId(ipOrderReceive.getId());
            }
        }
        //根据收货单获取收货信息
        IpOrderReceiverVo ipOrderReceiverVo = ipOrderReceiveMapper.selectByReceiverId(ipOrderReceiverSearchDto);

        if (ipOrderReceiverVo != null) {
            ipOrderReceiverVo.setGoods(this.getOrderReceiverGood(ipOrderReceiverSearchDto));
        }

        return ipOrderReceiverVo;
    }

    /**
     * 获取送货单商品信息
     *
     * @return
     */
    private List<IpOrderReceiverGoodVo> getOrderReceiverGood(IpOrderReceiverSearchDto ipOrderReceiverSearchDto) {
        List<IpOrderReceiverGoodVo> deliverGoodVoList = ipOrderReceiveGoodsMapper.getOrderReceiverGood(ipOrderReceiverSearchDto);
        for (IpOrderReceiverGoodVo ipOrderReceiverGoodVo : deliverGoodVoList) {
            ipOrderReceiverGoodVo.setUrlPath(basPath + ipOrderReceiverGoodVo.getUrlPath());
        }

        return deliverGoodVoList;
    }

    /**
     * 获取流程标题
     * @param deliverId
     * @return
     */
    private String getSubject(Long deliverId, String createId) {
        IpOrderDeliverSearchDto ipOrderDeliverSearchDto = new IpOrderDeliverSearchDto();
        ipOrderDeliverSearchDto.setDeliverId(deliverId);
        IpOrderDeliverVo ipOrderDeliverVo = ipOrderDeliverService.getDeliverDetail(ipOrderDeliverSearchDto);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ipOrderDeliverVo.getProjectName());
        stringBuilder.append("（");
        stringBuilder.append(ipOrderDeliverVo.getStagesName());
        stringBuilder.append("）");
        stringBuilder.append("收货确认");
        stringBuilder.append("（");
        stringBuilder.append(ipOrderDeliverVo.getDeliverNum());
        stringBuilder.append("）");
        return stringBuilder.toString();
    }

    /**
     * 查询是否收货并发起审批确认收货
     *
     */
    private Boolean bulidApproveTask(IpOrderReceiverDto ipOrderReceiverDto) throws Exception {
        if (ipOrderReceiverDto.getDeliverId() != null) {
            //根据流程实例号获取收货信息
            List<IpOrderReceive> ipOrderReceiveList = ipOrderReceiveMapper.selectByDeliverId(ipOrderReceiverDto.getDeliverId());
            if (ipOrderReceiveList.size() > 0 && null != ipOrderReceiveList.get(0).getInstid()) {
                TodoListDto listDto = new TodoListDto();
                listDto.setUserId(ipOrderReceiverDto.getUserid());
                listDto.setInstanceId(ipOrderReceiveList.get(0).getInstid());
                //获取待办记录
                ResultProcessTodoListDto result = ipcProcessService.getTodolist(listDto);
                if (Integer.valueOf(result.getTotal()) > 0) {
                    ApprovetaskDto atd = new ApprovetaskDto();
                    atd.setAction("agreed");
                    atd.setUserId(ipOrderReceiverDto.getUserid());
                    String taskId = result.getTaskInfos().get(0).getTaskId();
                    atd.setTaskId(taskId);
                    atd.setInstid(ipOrderReceiveList.get(0).getInstid());
                    atd.setProcessName("QRSH");
                    atd.setComment("确认收货");
                    ipcProcessService.approveTask(atd);
                    return false;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }
        return true;
    }
}
