package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpOrderReconciliationRecordMapper;
import com.ekingwin.bas.cloud.dao.IpOrderReconciliationSummaryMapper;
import com.ekingwin.bas.cloud.dto.IpOrderReconciliationRecordPageDto;
import com.ekingwin.bas.cloud.dto.IpOrderReconciliationSupplementDto;
import com.ekingwin.bas.cloud.entity.IpOrderReconciliationRecord;
import com.ekingwin.bas.cloud.entity.IpOrderReconciliationSummary;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationVo;
import com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode;
import com.ekingwin.bas.cloud.service.IpOrderReconciliationRecordService;
import com.ekingwin.bas.cloud.util.ExportExcelUtil;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpOrderReconciliationProjectExcelVo;
import com.ekingwin.bas.cloud.vo.IpOrderReconciliationRetailExcelVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;

import static com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode.YEARMONTHDAY;

/**
 * @ClassName: IpOrderReconciliationRecordServiceImpl
 * @Author: liujunfeng
 * @Date: 2019/11/28 15:11
 * @description:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpOrderReconciliationRecordServiceImpl extends BaseService implements IpOrderReconciliationRecordService {

    @Autowired
    IpOrderReconciliationRecordMapper recordMapper;

    @Autowired
    IpOrderReconciliationSummaryMapper summaryMapper;


    /**
     * 保存订单对账数据
     * @param orderReconciliationVos
     * @throws Exception
     */
    @Override
    public void saveReconciliation(List<IpOrderReconciliationVo> orderReconciliationVos)throws Exception {
        if (orderReconciliationVos != null && orderReconciliationVos.size() > 0){
            IpOrderReconciliationRecord reconciliationRecord;
            for (IpOrderReconciliationVo reconciliationVo : orderReconciliationVos){
                reconciliationRecord = new IpOrderReconciliationRecord();
                this.commonBuild(reconciliationRecord,reconciliationVo);
                String orderGoodsId = reconciliationVo.getOrderGoodsId();
                if (orderGoodsId != null){
                    //根据订单商品id获取订单商品详情
                    IpOrderReconciliationSupplementDto supplementDto = recordMapper.selectSupplement(Long.valueOf(orderGoodsId));
                    if (supplementDto != null){
                        reconciliationRecord.setProjectCode(supplementDto.getProjectCode());
                        reconciliationRecord.setProjectName(supplementDto.getProjectName());
                        reconciliationRecord.setInstallmentCode(supplementDto.getStagesCode());
                        reconciliationRecord.setInstallmentName(supplementDto.getStagesName());
                        reconciliationRecord.setContractCode(supplementDto.getContractCode());
                        reconciliationRecord.setContractName(supplementDto.getContractName());
                        reconciliationRecord.setOrderState(supplementDto.getState());
                        reconciliationRecord.setBillGoodsName(supplementDto.getBillGoodsName());
                        reconciliationRecord.setBillSpecifiModel(supplementDto.getBillTypeCode());
                        reconciliationRecord.setPriceType(supplementDto.getPricetype());
                        reconciliationRecord.setTaxTypeCode(supplementDto.getTaxTypeCode());
                        reconciliationRecord.setBrand(supplementDto.getBrand());
                        reconciliationRecord.setFtnpfirstcategorycode(supplementDto.getFtnpfirstcategorycode());
                        reconciliationRecord.setFtnpfirstcategoryname(supplementDto.getFtnpfirstcategoryname());
                        reconciliationRecord.setFtnpsecondcategorycode(supplementDto.getFtnpsecondcategorycode());
                        reconciliationRecord.setFtnpsecondcategoryname(supplementDto.getFtnpsecondcategoryname());
                        reconciliationRecord.setFtnpthreecategorycode(supplementDto.getFtnpthreecategorycode());
                        reconciliationRecord.setFtnpthreecategoryname(supplementDto.getFtnpthreecategoryname());
                    }
                }
                reconciliationRecord.setCreateDate(new Date());
                reconciliationRecord.setOrderStatus("0");
                //生成对账单号
                String recordNum= GenerateRequestCode.requestCode("reconciliationRecordNum", YEARMONTHDAY,4,"DZ");
                reconciliationRecord.setBillNumber(recordNum+"-"+reconciliationVo.getSupplierNum());
                reconciliationRecord.setShipper(reconciliationVo.getSupplierName());
                reconciliationRecord.setShipperId(reconciliationVo.getSupplierId());
                reconciliationRecord.setOrderQuantity(reconciliationVo.getOrderAccount());
                reconciliationRecord.setTheReceivingNum(reconciliationVo.getAccount());

                //供应商价格
                reconciliationRecord.setNotaxPriceSupplier(reconciliationVo.getSupplierNotaxprice());
                reconciliationRecord.setPriceSupplier(reconciliationVo.getSupplierPrice());
                reconciliationRecord.setTotalPriceSupplier(reconciliationVo.getSupplierTotalPrice());
                BigDecimal billTaxPrice = reconciliationVo.getSupplierPrice().multiply(StringUtils.stringToBigDecimal(reconciliationVo.getAccount()));
                reconciliationRecord.setBillTaxPrice(billTaxPrice);

                BigDecimal ddsl = StringUtils.stringToBigDecimal(reconciliationVo.getOrderAccount());
                BigDecimal bcshsl = StringUtils.stringToBigDecimal(reconciliationVo.getAccount());
                BigDecimal yshsl = StringUtils.stringToBigDecimal(reconciliationVo.getReceiverNum());
                BigDecimal yishou;
                BigDecimal num;
                if ("GR".equals(reconciliationRecord.getOrderType())){
                    yishou = bcshsl;
                    num = ddsl.subtract(bcshsl);
                }else {
                    yishou = yshsl.add(bcshsl);
                    num = ddsl.subtract(yshsl).subtract(bcshsl);
                }
                reconciliationRecord.setReceivingNum(String.valueOf(yishou));
                reconciliationRecord.setNotReceivingNum(String.valueOf(num));
                reconciliationRecord.setInputDate(new Date());
                recordMapper.saveReconciliationRecord(reconciliationRecord);

            }
        }
    }

    /**
     * 获取对账单列表
     * @param recordPageDto
     * @return
     * @throws Exception
     */
    @Override
    public PageInfo<IpOrderReconciliationRecord> getReconciliationRecordList(IpOrderReconciliationRecordPageDto recordPageDto) throws Exception {
        PageHelper.startPage(recordPageDto.getPagenum(), recordPageDto.getPagesize());
        List<IpOrderReconciliationRecord> recordDtos = recordMapper.selectReconciliationRecordList(recordPageDto);
        return new PageInfo<>(recordDtos);
    }

    @Override
    public void updateReconciliationOrderStatus(IpOrderReconciliationRecordPageDto recordDto) throws Exception {
        List<IpOrderReconciliationRecord> recordList = recordMapper.selectReconciliationRecord(recordDto.getOrderType());
        for (IpOrderReconciliationRecord record : recordList) {
            //XM 对账单进行汇总处理
            if ("XM".equals(record.getOrderType())) {
                IpOrderReconciliationSummary summary = summaryMapper.selectReconciliationSummary(record);
                if (summary == null) {
                    summary = new IpOrderReconciliationSummary();
                    this.commonBuild(summary, record);
                    summaryMapper.saveReconciliationSummary(summary);
                } else {
                    BigDecimal summaryShouHuShuLiang = StringUtils.stringToBigDecimal(summary.getTheReceivingNum());
                    BigDecimal recordsShouHuShuLiang = StringUtils.stringToBigDecimal(record.getTheReceivingNum());
                    BigDecimal heji = summaryShouHuShuLiang.add(recordsShouHuShuLiang);
                    summary.setTheReceivingNum(String.valueOf(heji));
                    if (recordsShouHuShuLiang.compareTo(BigDecimal.ZERO) != 0) {
                        summary.setIsInvoice("0");
                        summary.setIsPayment("0");
                    }
                    summary.setUpdateDate(new Date());
                    summary.setOrderGoodsId(record.getOrderGoodsId());
                    summary.setGoodsId(record.getGoodsId());
                    summary.setBillGoodsName(record.getBillGoodsName());
                    summary.setBillSpecifiModel(record.getBillSpecifiModel());
                    summary.setTaxTypeCode(record.getTaxTypeCode());
                    summary.setOrderQuantity(record.getOrderQuantity());
                    summary.setReceivingNum(record.getReceivingNum());
                    summary.setNotReceivingNum(record.getNotReceivingNum());
                    summaryMapper.updateReconciliationSummary(summary);
                }
            }
        }
        recordMapper.updateReconciliationOrderStatus(recordDto.getOrderType());
    }

    @Override
    public void getExcel(IpOrderReconciliationRecordPageDto ipOrderReconciliationRecordPageDto, HttpServletResponse response)throws Exception{
        //零售对账单导出
        if ("GR".equals(ipOrderReconciliationRecordPageDto.getOrderType())){
            this.excelRetailReconciliation(ipOrderReconciliationRecordPageDto,response);
        //项目对账单导出
        }else {
            this.excelProjectReconciliation(ipOrderReconciliationRecordPageDto,response);
        }
    }

    private void excelRetailReconciliation(IpOrderReconciliationRecordPageDto ipOrderReconciliationRecordPageDto, HttpServletResponse response) throws Exception {
        ExportExcelUtil<IpOrderReconciliationRetailExcelVo> util = new ExportExcelUtil<>();
        List<IpOrderReconciliationRetailExcelVo> recordDtos = recordMapper.getExcelRetail(ipOrderReconciliationRecordPageDto);
        String fileName = String.valueOf(System.currentTimeMillis()).substring(4, 13) + ".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr = "attachment; filename=\"" + encode + "\"";
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition",headStr);
        OutputStream outputStream = response.getOutputStream();
        String[] orderCloumn={
                "账单号","生成日期","订单号","订单总额","下单人","下单时间","商品编码","商品名称","开票商品名称",
                "开票规格型号","税收分类编码","品牌","一级分类","二级分类","三级分类","税率","综合不含税单价","综合含税单价",
                "小计","发货方","订单数量","已收货数量","未收货数量","对账含税金额","状态",
        };
        util.exportExcel("订单对账",orderCloumn,recordDtos,outputStream,ExportExcelUtil.EXCEl_FILE_2007);
        outputStream.flush();
        outputStream.close();
    }

    private void excelProjectReconciliation(IpOrderReconciliationRecordPageDto ipOrderReconciliationRecordPageDto, HttpServletResponse response) throws Exception {
        ExportExcelUtil<IpOrderReconciliationProjectExcelVo> util = new ExportExcelUtil<>();
        List<IpOrderReconciliationProjectExcelVo> recordDtos = recordMapper.getExcelProject(ipOrderReconciliationRecordPageDto);
        String fileName = String.valueOf(System.currentTimeMillis()).substring(4, 13) + ".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr = "attachment; filename=\"" + encode + "\"";
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition",headStr);
        OutputStream outputStream = response.getOutputStream();
        String[] orderCloumn={
                "账单号","生成日期","订单号","项目名称","分期","合同名称","订单总额","下单人","下单时间","商品编码",
                "商品名称","开票商品名称","开票规格型号","价格类型","税收分类编码","品牌","一级分类","二级分类","三级分类","税率",
                "综合不含税单价","综合含税单价","小计","发货方","运费","订单数量","已收货数量","未收货数量","对账含税金额","状态",
        };
        util.exportExcel("订单对账",orderCloumn,recordDtos,outputStream,ExportExcelUtil.EXCEl_FILE_2007);
        outputStream.flush();
        outputStream.close();
    }

}
