package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpOrderReportMapper;
import com.ekingwin.bas.cloud.dao.IpOrderSupplerHomeMapper;
import com.ekingwin.bas.cloud.dto.IpOrderReportDto;
import com.ekingwin.bas.cloud.dto.IpOrderSupplierHomeDto;
import com.ekingwin.bas.cloud.dto.IpQueryOperatorDto;
import com.ekingwin.bas.cloud.service.IpOrderReportService;
import com.ekingwin.bas.cloud.util.ExportExcelUtil;
import com.ekingwin.bas.cloud.util.JsonStringUtils;
import com.ekingwin.bas.cloud.vo.IpOrderReportExcelVo;
import com.ekingwin.bas.cloud.vo.IpOrderReportVo;
import com.ekingwin.bas.cloud.vo.IpOrderSupplierHomeDayVo;
import com.ekingwin.bas.cloud.vo.IpOrderSupplierHomeVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-23 10:49
 **/
@Service
@Primary
public class IpOrderReportServiceImpl implements IpOrderReportService {


    @Autowired
    private IpOrderReportMapper ipOrderReportMapper;


    @Autowired
    private IpOrderSupplerHomeMapper ipOrderSupplerHomeMapper;


    /**
     * 查询我的订单列表
     * @param ipOrderReportDto
     * @return
     */
    @Override
    public PageInfo getOrderReport(IpOrderReportDto ipOrderReportDto){
        //判断是否是管理员，管理员查询所有的订单
        Integer count=ipOrderReportMapper.checkUserGly(ipOrderReportDto.getUserid());
        if (count>0){
            ipOrderReportDto.setIsAdministr("Y");
        }
        //获取查询条件
        List<IpQueryOperatorDto> boOperatorModels = ipOrderReportDto.getQuery();
        if (boOperatorModels != null && boOperatorModels.size() > 0) {
            ipOrderReportDto.setCurreySql(this.spiltCurrsql(boOperatorModels));
        }
        PageHelper.startPage(ipOrderReportDto.getPagenum(),ipOrderReportDto.getPagesize());
        List<IpOrderReportVo> ipOrderReportVos=ipOrderReportMapper.getOrderReport(ipOrderReportDto);
        PageInfo page =new PageInfo<>(ipOrderReportVos);
        return page;
    }

    /**
     * 拼接sql数据
     * @param boOperatorModels
     * @return
     */
    private String spiltCurrsql(List<IpQueryOperatorDto> boOperatorModels) {
        StringBuilder builder = new StringBuilder();
        builder.append("1=1 ");
        for (IpQueryOperatorDto boOperatorModel : boOperatorModels) {
            builder.append(JsonStringUtils.spiltSql(boOperatorModel.getOperator(), boOperatorModel.getColumn(),
                    boOperatorModel.getValue(), boOperatorModel.getDataType()));
        }
        return builder.toString();
    }

    /**
     * 获取供应商首页的订单统计
     * @param ipOrderSupplierHomeDto
     * @return
     */
    @Override
    public IpOrderSupplierHomeVo getSupplierHome(IpOrderSupplierHomeDto ipOrderSupplierHomeDto){
        IpOrderSupplierHomeVo ipOrderSupplierHomeVo=new IpOrderSupplierHomeVo();
        String supplierid=ipOrderSupplierHomeDto.getSupplierid();

        BigDecimal totalPrice =ipOrderSupplerHomeMapper.getSupplierTotal(supplierid);
        if (totalPrice==null){
            totalPrice=new BigDecimal("0.00");
        }
        //计算总销售额
        ipOrderSupplierHomeVo.setTotalsales(totalPrice);

        //计算当日销售额
        BigDecimal todayTotal=ipOrderSupplerHomeMapper.getSupplierTodayTotal(supplierid);
        if (todayTotal==null){
            todayTotal=new BigDecimal("0.00");
        }
        ipOrderSupplierHomeVo.setTodaytotalsales(todayTotal);

        //计算当日订单数量
        Integer nowOrder=ipOrderSupplerHomeMapper.getSupplierTodayCount(supplierid);
        if (nowOrder==null){
            nowOrder=0;
        }
        ipOrderSupplierHomeVo.setTodayordernum(nowOrder);

        //获取收货数量
        Integer deliverCount=ipOrderSupplerHomeMapper.getSupplierDeliverCount(supplierid);
        if (deliverCount==null){
            deliverCount=0;
        }
        ipOrderSupplierHomeVo.setDeliveryorder(deliverCount);

        //获取待发货数量
        Integer supplierNoDeliverCount=ipOrderSupplerHomeMapper.getSupplierNoDeliverCount(supplierid);
        if (supplierNoDeliverCount==null){
            supplierNoDeliverCount=0;
        }
        ipOrderSupplierHomeVo.setWaitdeliveryorder(supplierNoDeliverCount);

        //上传商品数
        Integer uploadGoodsCount = ipOrderSupplerHomeMapper.getUploadGoodsCount(supplierid);
        ipOrderSupplierHomeVo.setUploadGoodsCount(uploadGoodsCount);

        return ipOrderSupplierHomeVo;
    }

    /**
     * 供应商七日
     * @param supplierid
     * @return
     */
    @Override
    public List<IpOrderSupplierHomeDayVo> getSupplierDay(String supplierid){

        return   ipOrderSupplerHomeMapper.getSupplierDay(supplierid);
    }

//文件报表导出
   /* @Override
    public void getExcel(IpOrderReportExcelVo ipOrderReportExcelVo, HttpServletResponse response) throws Exception {
        ExportExcelUtil<IpOrderReportExcelVo> util = new ExportExcelUtil<>();

        List<IpOrderReportExcelVo> orderReportExcel = ipOrderReportMapper.getExcel(ipOrderReportExcelVo);
        //表文件名
        String fileName= String.valueOf(System.currentTimeMillis()).substring(4,13)+".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr = "attachment; filename=\"" + encode + "\"";
        //转八进制
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition",headStr);
        response.addHeader("Content-type","application-download");
        //得到输出流
        OutputStream outputStream = response.getOutputStream();
        String[] orderReportCloumn={
                "订单编号","订单ID","项目名称","项目编号","分期编号","分期名称","合同编号","合同名称","订单总额","下单人","下单人工号",
                "下单时间","状态","商品名称","商品编码","一级分类","二级分类","三级分类","税收分类编码","开票商品名称","开票规格型号",   "价格类型","品牌", "税率", "含税单价","不含税单价","开票类型","开票类型","发货方标识","发货方","发货数量", "收货数量",
                "未收货数量","总数量","审批时间", "小计","商品运费","订单类型"
        };
        util.exportExcel("订单汇总",orderReportCloumn,orderReportExcel,outputStream,ExportExcelUtil.EXCEl_FILE_2007);
        outputStream.flush();
        outputStream.close();
    }*/

    /**
     * excel导出
     * @param ipOrderReportDto
     * @param response
     * @throws Exception
     */
    @Override
    public void  getExcel(IpOrderReportDto ipOrderReportDto, HttpServletResponse response)throws Exception{
        Integer count=ipOrderReportMapper.checkUserGly(ipOrderReportDto.getUserid());
        if (count>0){
            ipOrderReportDto.setIsAdministr("Y");
        }
        List<IpQueryOperatorDto> boOperatorModels = ipOrderReportDto.getQuery();
        if (boOperatorModels != null && boOperatorModels.size() > 0) {
            ipOrderReportDto.setCurreySql(this.spiltCurrsql(boOperatorModels));
        }

        List<IpOrderReportExcelVo> ipOrderReportVos=ipOrderReportMapper.getExcel(ipOrderReportDto);

        ExportExcelUtil<IpOrderReportExcelVo> util = new ExportExcelUtil<>();

        //表文件名
        String fileName= String.valueOf(System.currentTimeMillis()).substring(4,13)+".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr = "attachment; filename=\"" + encode + "\"";
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition",headStr);

        OutputStream outputStream = response.getOutputStream();
        String[] orderCloumn={
                "订单编号","项目名称","分期名称","合同名称","订单总额","下单人","下单时间","状态","商品名称","商品编码",
                "一级分类","二级分类","三级分类","税收分类编码","开票商品名称","开票规格型号","价格类型","品牌",
                "税率","含税单价","不含税单价","开票类型","发货方","数量","小计",
                "已收货数量","未收货数量"
        };
        util.exportExcel("订单汇总",orderCloumn,ipOrderReportVos,outputStream,ExportExcelUtil.EXCEl_FILE_2007);
        outputStream.flush();
        outputStream.close();
    }

}
