package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpOrderReconciliationSummaryMapper;
import com.ekingwin.bas.cloud.dao.IpPaymentDetailMapper;
import com.ekingwin.bas.cloud.dao.IpPaymentMapper;
import com.ekingwin.bas.cloud.dao.IpPaymentPayInfoMapper;
import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.dto.sapmessage.PaymentPayAppItemInfoDto;
import com.ekingwin.bas.cloud.dto.sapmessage.SapPaymentReturnDto;
import com.ekingwin.bas.cloud.entity.IpOrderReconciliationSummary;
import com.ekingwin.bas.cloud.entity.IpPayment;
import com.ekingwin.bas.cloud.entity.IpPaymentDetail;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.rabbit.sender.SapPaymentSender;
import com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode;
import com.ekingwin.bas.cloud.service.IpPaymentService;
import com.ekingwin.bas.cloud.util.ExportExcelUtil;
import com.ekingwin.bas.cloud.vo.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode.YEARMONTHDAY;

@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpPaymentServiceImpl extends BaseService implements IpPaymentService {

    @Autowired
    private IpPaymentMapper ipPaymentMapper;
    @Autowired
    private IpPaymentDetailMapper ipPaymentDetailMapper;
    @Autowired
    private IpPaymentPayInfoMapper ipPaymentPayInfoMapper;

    @Autowired
    IpOrderReconciliationSummaryMapper orderReconciliationSummaryMapper;

    @Autowired
    SapPaymentSender sapPaymentSender;


    @Override
    public PageInfo<IpPaymentVo> getPaymentInfo(IpPaymentPageDto ipPaymentPageDto) throws Exception {
        PageHelper.startPage(ipPaymentPageDto.getPagenum(), ipPaymentPageDto.getPagesize());
        List<IpPaymentVo> paymentVoList = ipPaymentMapper.getPaymentInfo(ipPaymentPageDto);
        return new PageInfo<>(paymentVoList);
    }

    @Override
    public IpPaymentDto queryPayment(IpPaymentPageDto ipPaymentPageDto) throws Exception {
        IpPaymentDto paymentDto = ipPaymentMapper.getPayment(ipPaymentPageDto.getId());
        String attachment = paymentDto.getAttachment();
        if (StringUtils.isNotBlank(attachment)) {
            List<Documentation> files = this.getFiles(attachment);
            paymentDto.setFiles(files);
        }
        if ("N".equals(ipPaymentPageDto.getConditions())) {
            List<IpPaymentDetailDto> detailDtoList = ipPaymentDetailMapper.selectPaymentDetailDto(ipPaymentPageDto.getId());
            paymentDto.setPayment(detailDtoList);
        }
        return paymentDto;
    }


    @Override
    public String saveOrUpdatePaymen(IpPaymentDto ipPaymentDto) throws Exception {
        Long id = ipPaymentDto.getId();
        if (id == null) {
            IpPayment ipPayment = new IpPayment();
            this.commonBuild(ipPayment, ipPaymentDto);
            ipPayment.setApplicantCode(ipPaymentDto.getUserid());
            ipPayment.setSupplierId(ipPaymentDto.getUserid());
            ipPayment.setApplicantName(ipPaymentDto.getUserName());
            //生成付款单号
            String paymentNum = ipPayment.getApplyForNum();
            //判断是否存在申请单号，不存在则生成单号
            if (StringUtils.isEmpty(paymentNum)) {
                paymentNum = GenerateRequestCode.requestCode("paymentNum", YEARMONTHDAY, 4, "FKD");

            }
            ipPayment.setApplyForNum(paymentNum);
            ipPaymentDto.setApplyForNum(paymentNum);
            ipPayment.setState("供应商已提交");
            ipPaymentMapper.saveIpPayment(ipPayment);
            Long i = ipPayment.getId();
            this.savePaymentDetail(ipPaymentDto, i);
        } else {
            IpPayment ipPayment = new IpPayment();
            this.commonBuild(ipPayment, ipPaymentDto);
            ipPayment.setUpdateTime(new Date());
            ipPaymentMapper.updateIpPayment(ipPayment);
            ipPaymentDetailMapper.deletePaymentDetail(id);
            this.savePaymentDetail(ipPaymentDto, id);
        }
        //同步付款申请到SAP
        this.initPaymentRecord(ipPaymentDto);

        return null;
    }

    private void initPaymentRecord(IpPaymentDto ipPaymentDto) throws Exception {
        IpSapPaymentVo sapPaymentVo = new IpSapPaymentVo();
        this.commonBuild(sapPaymentVo, ipPaymentDto);
        if ("0".equals(ipPaymentDto.getApplicationType())){
            sapPaymentVo.setPaymentTypes("03");
        }else {
            sapPaymentVo.setPaymentTypes("04");
        }
        //项目信息
        List<IpPaymentDetailDto> detailDtos = ipPaymentDto.getPayment();
        if (detailDtos != null && detailDtos.size() > 0) {
            List<IpSapPaymentDetailVo> sapDetailVos = new ArrayList<>();
            IpSapPaymentDetailVo sapDetailVo;
            for (IpPaymentDetailDto detailDto : detailDtos) {
                sapDetailVo = new IpSapPaymentDetailVo();
                this.commonBuild(sapDetailVo, detailDto);
                sapDetailVo.setPaymentNo(ipPaymentDto.getApplyForNum());
                sapDetailVos.add(sapDetailVo);
            }
            sapPaymentVo.setPaymentProjects(sapDetailVos);
        }
        ObjectMapper mapper = new ObjectMapper();
        //格式化输出
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        //键按自然顺序输出
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        String requestJson = mapper.writeValueAsString(sapPaymentVo);
        sapPaymentSender.send("order.sappayment.info", requestJson);
    }

    private List<Documentation> getFiles(String attachment) {
        List<String> ids = new ArrayList<>();
        if (StringUtils.isNotEmpty(attachment)) {
            String[] split = attachment.split(",");
            if (split.length > 0) {
                for (String s : split) {
                    ids.add(s);
                }
            }
        }
        return ipPaymentMapper.getFiles(ids);
    }

    private void savePaymentDetail(IpPaymentDto ipPaymentDto, Long id) throws Exception {
        List<IpPaymentDetailDto> payment1 = ipPaymentDto.getPayment();
        if (payment1 != null && payment1.size() > 0) {
            IpPaymentDetail ipPaymentDetail;
            for (IpPaymentDetailDto payment : payment1) {
                Long summaryId = this.saveOrUpdateSummary(payment,ipPaymentDto);

                ipPaymentDetail = new IpPaymentDetail();
                this.commonBuild(ipPaymentDetail, payment);
                ipPaymentDetail.setId(null);
                ipPaymentDetail.setPaymentId(id);
                ipPaymentDetail.setSorte(summaryId);
                ipPaymentDetailMapper.savePaymentDetail(ipPaymentDetail);
            }
        }

    }


    @Override
    public PageInfo<IpPaymentPayInfoDto> sapDetailList(IpPaymentPayInfoDto payInfoDto) throws Exception {
        PageHelper.startPage(payInfoDto.getPagenum(), payInfoDto.getPagesize());
        List<IpPaymentPayInfoDto> payInfoDtos = ipPaymentPayInfoMapper.selectInvoiceList(payInfoDto.getApplyForNum());
        return new PageInfo<>(payInfoDtos);
    }

    @Override
    public PageInfo<IpPaymentContractVo> getContractChoice(IpPaymentPayInfoDto payInfoDto) throws Exception {
        PageHelper.startPage(payInfoDto.getPagenum(), payInfoDto.getPagesize());
        List<IpPaymentContractVo> contractList = ipPaymentPayInfoMapper.getContractChoice(payInfoDto);
        return new PageInfo<>(contractList);
    }

    @Override
    public List<String> getReconciliationChoice(IpPaymentPayInfoDto payInfoDto) throws Exception {
        return ipPaymentPayInfoMapper.getReconciliationChoice(payInfoDto);
    }

    @Override
    public List<IpPaymentApplyVo> getRetailPurchasesList(IpPurchasesDto purchasesDto) throws Exception {
        List<IpPaymentApplyVo> applyVos = ipPaymentPayInfoMapper.getRetailPurchasesList(purchasesDto);
        return applyVos;
    }

    @Override
    public IpPaymentApplyVo getEngineeringPurchasesList(IpPurchasesDto purchasesDto) throws Exception {
        IpPaymentApplyVo paymentApplyVo = ipPaymentPayInfoMapper.getEngineeringPurchasesList(purchasesDto);
        if (StringUtils.isNotBlank(purchasesDto.getGoodsContractId())){
            IpPaymentApplyVo paymentApplyVoHb = ipPaymentPayInfoMapper.getEngineeringPurchasesListHb(purchasesDto);
            if (paymentApplyVoHb != null){
                paymentApplyVo.setContCny(paymentApplyVoHb.getContCny());
                paymentApplyVo.setNewAmtTax(paymentApplyVoHb.getNewAmtTax());
                paymentApplyVo.setNewAmt(paymentApplyVoHb.getNewAmt());
            }
        }
        if (paymentApplyVo != null) {
            List<IpPaymentDetailVo> paymentDetailVos = ipPaymentPayInfoMapper.getEngineeringDetail(purchasesDto);
            paymentApplyVo.setPaymentDetailVos(paymentDetailVos);
        }
        return paymentApplyVo;
    }


    @Override
    public void getExcel(IpPaymentPageDto ipPaymentPageDto, HttpServletResponse response) throws Exception {
        List<IpPaymentExcelVo> paymentVoList = ipPaymentMapper.getExcel(ipPaymentPageDto);
        ExportExcelUtil<IpPaymentExcelVo> util = new ExportExcelUtil<>();
        //表文件名
        String fileName = String.valueOf(System.currentTimeMillis()).substring(4, 13) + ".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr = "attachment; filename=\"" + encode + "\"";
        //转八进制
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition", headStr);
        // response.addHeader("Content-type","application-download");
        //得到输出流
        OutputStream outputStream = response.getOutputStream();
        String[] paymentCloumn = {
                "申请单号","申请总额","申请时间","审定金额","合同名称","合同编码","合同金额","状态"
        };
        util.exportExcel("付款申请", paymentCloumn, paymentVoList, outputStream, ExportExcelUtil.EXCEl_FILE_2007);
        outputStream.flush();
        outputStream.close();
    }

    @Override
    public void sapPaymentReturn(SapPaymentReturnDto paymentReturnDto) {
        ipPaymentMapper.updatePaymentStart(paymentReturnDto);
        if ("04".equals(paymentReturnDto.getPaymentstatus())) {
            Long id = ipPaymentMapper.selectPaymentId(paymentReturnDto.getPaymentno());
            this.dealWith(id);
        }else {
            this.dealWithAll(paymentReturnDto);
        }
    }

    private void dealWithAll(SapPaymentReturnDto paymentReturnDto){
        List<PaymentPayAppItemInfoDto> payAppItemInfoList = paymentReturnDto.getPayAppItemInfo();
        if (payAppItemInfoList != null && payAppItemInfoList.size() >0){
            for (PaymentPayAppItemInfoDto payAppItemInfo : payAppItemInfoList){
                String contractCode = orderReconciliationSummaryMapper.selectcontractCode(payAppItemInfo.getPayano());
                IpOrderReconciliationSummary summary = orderReconciliationSummaryMapper.selectReconciliationGoodsCode(payAppItemInfo.getGoodsnum(),contractCode);
                IpPaymentDetailDto detailDto = ipPaymentDetailMapper.selectPaymentDetailNumber(paymentReturnDto.getPaymentno(),payAppItemInfo.getGoodsnum());
                //实际支付数量
                BigDecimal zhifushuliang =  com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(payAppItemInfo.getAmount().trim());
                BigDecimal zhifuprice = payAppItemInfo.getAmtincltax();
                //申请付款数量
                BigDecimal shengqishuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(detailDto.getApplyNum());
                BigDecimal shengqiprice = shengqishuliang.multiply(detailDto.getPrice());
                //未支付数量
                BigDecimal weizhifushuliang = shengqishuliang.subtract(zhifushuliang);
                BigDecimal weizhifuprice = shengqiprice.subtract(zhifuprice);
                //总计申请数量
                BigDecimal leijishengqishuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(summary.getPaymentnum());
                BigDecimal leijishengqiprice = summary.getPaymentprice();
                //总计支付数量
                BigDecimal leijizhifushuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(summary.getPaymentactual());
                BigDecimal paymentnum = leijishengqishuliang.subtract(weizhifushuliang);
                BigDecimal paymentprice = leijishengqiprice.subtract(weizhifuprice);
                BigDecimal paymentactual = leijizhifushuliang.add(zhifushuliang);
                summary.setPaymentnum(String.valueOf(paymentnum));
                summary.setPaymentprice(paymentprice);
                summary.setPaymentactual(String.valueOf(paymentactual));
                if ("1".equals(summary.getIsPayment()) && weizhifushuliang.compareTo(BigDecimal.ZERO) != 0) {
                    summary.setIsPayment("0");
                }
                orderReconciliationSummaryMapper.updateReconciliationSummary(summary);
            }
        }
    }

    private void dealWith(Long id) {
        List<IpPaymentDetail> details = ipPaymentDetailMapper.selectPaymentDetail(id);
        if (details != null && details.size() > 0) {
            for (IpPaymentDetail detail : details) {
                String contractCode = ipPaymentDetailMapper.selectcontractCode(id);
                IpOrderReconciliationSummary summary = orderReconciliationSummaryMapper.selectReconciliationGoodsCode(detail.getGoodsCode(),contractCode);
                BigDecimal becishuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(detail.getApplyNum());
                BigDecimal lishishuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(summary.getPaymentnum());
                BigDecimal lishiprice = summary.getPaymentprice();
                BigDecimal yuanjia = detail.getPrice();
                BigDecimal beciprice = becishuliang.multiply(yuanjia);

                BigDecimal paymentnum = lishishuliang.subtract(becishuliang);
                BigDecimal paymentprice = lishiprice.subtract(beciprice);
                summary.setPaymentnum(String.valueOf(paymentnum));
                summary.setPaymentprice(paymentprice);
                if ("1".equals(summary.getIsPayment())) {
                    summary.setIsPayment("0");
                }
                orderReconciliationSummaryMapper.updateReconciliationSummary(summary);
            }
        }
    }

    private Long saveOrUpdateSummary(IpPaymentDetailDto payment,IpPaymentDto ipPaymentDto){
        Long summaryId = null;

        BigDecimal yiduizhangshuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(payment.getCheckeAmount());
        BigDecimal bencishengqishuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(payment.getApplyNum());
        BigDecimal yishouhushuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(payment.getReceivedGoodsNo());
        BigDecimal checkeamount = yiduizhangshuliang.add(bencishengqishuliang);
        BigDecimal benciprice = payment.getTaxAmountGoods();
        IpOrderReconciliationSummary summary = orderReconciliationSummaryMapper.selectReconciliationGoodsCode(payment.getGoodsCode(),ipPaymentDto.getContractCode());
        if (summary != null){
            BigDecimal lishishuliang = com.ekingwin.bas.cloud.util.StringUtils.stringToBigDecimal(summary.getPaymentnum());
            BigDecimal lishiprice = summary.getPaymentprice();
            BigDecimal paymentnum = lishishuliang.add(bencishengqishuliang);
            BigDecimal paymentprice = lishiprice.add(benciprice);
            summary.setPaymentnum(String.valueOf(paymentnum));
            summary.setPaymentprice(paymentprice);
            //发起发票记录后修改订单对账状态
            if (yishouhushuliang != null && checkeamount != null) {
                if (yishouhushuliang.compareTo(checkeamount) == 0) {
                    summary.setIsPayment("1");
                }
            }
            summaryId = summary.getId();
            orderReconciliationSummaryMapper.updateReconciliationSummary(summary);
        }else {
            IpOrderReconciliationSummary summarys = new IpOrderReconciliationSummary();
            summarys.setGoodsnum(payment.getGoodsCode());
            summarys.setContractCode(ipPaymentDto.getContractCode());
            summarys.setShipperId(ipPaymentDto.getApplicantCode());
            summarys.setOrderType("XM");
            summarys.setInputDate(new Date());
            summarys.setGoodsName(payment.getGoodsName());
            summarys.setContractName(ipPaymentDto.getContractName());
            summarys.setRate(payment.getRate());
            summarys.setNotaxPrice(payment.getSalePriceNoTax());
            summarys.setPrice(payment.getSalePrice());
            summarys.setNotaxPriceSupplier(payment.getPriceNoTax());
            summarys.setPriceSupplier(payment.getPrice());
            summarys.setPaymentnum(payment.getApplyNum());
            summarys.setPaymentprice(payment.getTaxAmountGoods());
            summarys.setShipperId(ipPaymentDto.getSupplierId());
            summaryId = orderReconciliationSummaryMapper.saveReconciliationSummary(summarys);
        }
        return summaryId;
    }

}







