package com.ekingwin.bas.cloud.service.impl;


import com.ekingwin.bas.cloud.dao.ContractMapper;
import com.ekingwin.bas.cloud.dao.IpProjectContractManagerMapper;
import com.ekingwin.bas.cloud.dto.IpProjectContractDetailDto;
import com.ekingwin.bas.cloud.dto.IpProjectContractManagerDto;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.service.IpProjectContractManagerService;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpProjectContractGoodsListVo;
import com.ekingwin.bas.cloud.vo.IpProjectContractListVo;
import com.ekingwin.bas.cloud.vo.IpProjectContractSearchDetailVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yuzm
 * @date 2019/10/14 9:36
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpProjectContractManagerServiceImpl extends BaseService implements IpProjectContractManagerService {

    @Autowired
    private IpProjectContractManagerMapper projectContractManagerMapper;


    @Autowired
    private ContractMapper contractMapper;

    /**
     * 查询合同列表
     * @param managerDto
     * @return
     */
    @Override
    public PageInfo selectProjectContractList(IpProjectContractManagerDto managerDto) {
        List<IpProjectContractListVo> listVos=new ArrayList<>();
        //判断是否是供应商
        if (StringUtils.isNotEmpty(managerDto.getSupplierid())){
            PageHelper.startPage(managerDto.getPagenum(),managerDto.getPagesize());
            listVos = contractMapper.selectContractSupplierid(managerDto);
        }else {
            if ("Y".equals(managerDto.getProjectNo())){
                String companyId = contractMapper.selectCompanyIds(managerDto.getCompanyId());
                List<String> companyIds = new ArrayList<String>();
                if (StringUtils.isNotEmpty(companyId)){
                    String [] sts=companyId.split(",");
                    if (sts.length>0){
                        for (String st : sts) {
                            companyIds.add(st);
                        }
                    }
                }
                List<String> projectNos = contractMapper.selectProjectNo(companyIds);
                managerDto.setProjectNos(projectNos);
                if (projectNos !=null && projectNos.size()>0){
                    //项目采购合同
                    PageHelper.startPage(managerDto.getPagenum(),managerDto.getPagesize());
                    listVos = contractMapper.selectContractXm(managerDto);
                }

            }else {
                //致融采购合同 //致融销售合同
                PageHelper.startPage(managerDto.getPagenum(),managerDto.getPagesize());
                listVos = contractMapper.selectContractHb(managerDto);
            }
        }
        List<IpProjectContractListVo> contractListVos = this.selectGoods(listVos,managerDto.getContractType());
        return new PageInfo<>(contractListVos);
    }

    /**
     * 查询合同详情
     *
     * @param ipProjectContractDetailDto
     * @return
     */
    @Override
    public IpProjectContractSearchDetailVo selectProjectContractDetail(IpProjectContractDetailDto ipProjectContractDetailDto) {
        IpProjectContractSearchDetailVo searchDetailVo = null;
        Integer id = ipProjectContractDetailDto.getId();
        if (id != null) {
            searchDetailVo = projectContractManagerMapper.selectProjectContractDetail(id);
            searchDetailVo.setContProductInfoVos(projectContractManagerMapper.selectContProduct(id));
            searchDetailVo.setContAttachInfoVos(projectContractManagerMapper.selectContAttach(id));
        }
        return searchDetailVo;
    }


    @Override
    public IpProjectContractSearchDetailVo selectProjectContract(String contractId) {
        return projectContractManagerMapper.selectProjectContract(contractId);
    }


    private List<IpProjectContractListVo> selectGoods(List<IpProjectContractListVo> listVos,String type){
        if ("XM".equals(type)){
            if (listVos != null && listVos.size() > 0){
                for (int x=0;x<listVos.size();x++){
                    List<IpProjectContractGoodsListVo> goodsListVos = contractMapper.selectGoodsXM(listVos.get(x));
                    listVos.get(x).setGoodsListVos(goodsListVos);
                }
            }
        }else {
            if (listVos != null && listVos.size() > 0){
                for (int x=0;x<listVos.size();x++){
                    List<IpProjectContractGoodsListVo> goodsListVos = contractMapper.selectGoodsHB(listVos.get(x));
                    listVos.get(x).setGoodsListVos(goodsListVos);
                }
            }
        }
        return listVos;
    }
}
