package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpProjectMapper;
import com.ekingwin.bas.cloud.dao.IpProjectUserMapper;
import com.ekingwin.bas.cloud.dto.IpProjectSearchDto;
import com.ekingwin.bas.cloud.dto.IpProjectUserDto;
import com.ekingwin.bas.cloud.entity.IpProjectUser;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.infra.utils.web.UserUtils;
import com.ekingwin.bas.cloud.service.IpProjectService;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpProjectStagesUserVo;
import com.ekingwin.bas.cloud.vo.IpProjectStagesVo;
import com.ekingwin.bas.cloud.vo.IpProjectUserVo;
import com.ekingwin.bas.cloud.vo.IpProjectVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-29 17:39
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpProjectServiceImpl  implements IpProjectService {

    @Autowired
    private IpProjectMapper ipProjectMapper;
    @Resource
    private IpProjectUserMapper ipProjectUserMapper;

    /**
     * 查询项目
     * @param ipProjectSearchDto
     * @return
     */
    @Override
    public PageInfo  getProject(IpProjectSearchDto ipProjectSearchDto){
         List<IpProjectVo> projects=null;
        if (StringUtils.isNotEmpty(ipProjectSearchDto.getIsPower()) && ipProjectSearchDto.getIsPower().equals("Y")){
            String companyId=ipProjectSearchDto.getCompanyId();
            List<String> orgList=ipProjectUserMapper.getEmployUser(ipProjectSearchDto.getUserid());
                Set<String> orgStr = new HashSet<String>();
                Set<String> parentStr = new HashSet<String>();
                    String string=ipProjectUserMapper.getTree(companyId);
                    if (StringUtils.isNotEmpty(string)){
                        String [] sts=string.split(",");
                        if (sts.length>0){
                            for (String st : sts) {
                                orgStr.add(st);
                            }
                        }
                    }
                if (orgStr.size()>0 || parentStr.size()>0){
                    ipProjectSearchDto.setUserTreeUser(String.join(",",orgStr));
                    ipProjectSearchDto.setUserParentTreeUser(String.join(",",parentStr));
                    PageHelper.startPage(ipProjectSearchDto.getPagenum(),ipProjectSearchDto.getPagesize());
                    projects =ipProjectMapper.getAllProject(ipProjectSearchDto);
                }
        }else {

            PageHelper.startPage(ipProjectSearchDto.getPagenum(),ipProjectSearchDto.getPagesize());
            projects =ipProjectMapper.getAllProject(ipProjectSearchDto);
        }



        PageInfo pageInfo = new PageInfo<>(projects);
        return  pageInfo;
    }

    /**
     * 获取分期数据
     * @param ipProjectSearchDto
     * @return
     */
    @Override
    public List<IpProjectStagesVo> getStages(IpProjectSearchDto ipProjectSearchDto){
        return ipProjectMapper.getStages(ipProjectSearchDto);
    }

    /**
     * 获取项目联系人
     * @param ipProjectSearchDto
     * @return
     */
    @Override
    public List<IpProjectStagesUserVo> getStagesUser(IpProjectSearchDto ipProjectSearchDto){
        return ipProjectMapper.getStagesUser(ipProjectSearchDto);
    }


    /**
     * 查询项目分期下的收货方信息
     * @param
     */
    @Override
    public PageInfo getProjectReceiverUser(IpProjectUserDto ipProjectUserDto){
        PageHelper.startPage(ipProjectUserDto.getPagenum(), ipProjectUserDto.getPagesize());
        List<IpProjectUserVo> ipProjectVoList = ipProjectUserMapper.getProjectReceiverPage(ipProjectUserDto);
        PageInfo<IpProjectUserVo> ipProjectUserPageInfo = new PageInfo<>(ipProjectVoList);
        return ipProjectUserPageInfo;
    }

    @Override
    public int insertOrUpdateReceiverUser(IpProjectUserDto ipProjectUserDto) {
        List<IpProjectUser> projectUserList = ipProjectUserMapper.selectProjectStagesCode(ipProjectUserDto.getStagesCode());
        int result = 0;
        Long id = ipProjectUserDto.getId();
        if ((projectUserList == null || projectUserList.size() == 0) || StringUtils.isNotEmpty(id)){
            if(StringUtils.isEmpty(id)){
                IpProjectUser ipProjectUser = new IpProjectUser();
                BeanUtils.copyProperties(ipProjectUserDto,ipProjectUser);
                ipProjectUser.setStatus(1);
                ipProjectUser.setCreateTime(new Date());
                ipProjectUser.setCreateBy(UserUtils.getCurrentUser());
                result = ipProjectUserMapper.insertSelective(ipProjectUser);
            }else {
                IpProjectUser ipProjectUser = new IpProjectUser();
                BeanUtils.copyProperties(ipProjectUserDto,ipProjectUser);
                ipProjectUser.setUpdateTime(new Date());
                ipProjectUser.setCreateBy(UserUtils.getCurrentUser());
                result = ipProjectUserMapper.updateByPrimaryKeySelective(ipProjectUser);
            }
            return result;
        }else {
            return result;
        }
    }

    @Override
    public int deleteReceiverUser(IpProjectUserDto ipProjectUserDto) {
        Long id = ipProjectUserDto.getId();
        int result;
        if(!StringUtils.isEmpty(id)){
            IpProjectUser ipProjectUser = new IpProjectUser();
            BeanUtils.copyProperties(ipProjectUserDto,ipProjectUser);
            ipProjectUser.setStatus(0);
            result = ipProjectUserMapper.updateByPrimaryKeySelective(ipProjectUser);
        }else {
            throw new BusinessException(500,"缺少当前操作列id");
        }
        return result;
    }
}
